package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.computeoptimizer.model.primitives.{
  InstanceArn,
  AccountId,
  LastRefreshTimestamp,
  LookBackPeriodInDays,
  InstanceName,
  CurrentInstanceType
}
import scala.jdk.CollectionConverters._
final case class InstanceRecommendation(
    instanceArn: Option[InstanceArn] = None,
    accountId: Option[AccountId] = None,
    instanceName: Option[InstanceName] = None,
    currentInstanceType: Option[CurrentInstanceType] = None,
    finding: Option[zio.aws.computeoptimizer.model.Finding] = None,
    findingReasonCodes: Option[Iterable[
      zio.aws.computeoptimizer.model.InstanceRecommendationFindingReasonCode
    ]] = None,
    utilizationMetrics: Option[
      Iterable[zio.aws.computeoptimizer.model.UtilizationMetric]
    ] = None,
    lookBackPeriodInDays: Option[LookBackPeriodInDays] = None,
    recommendationOptions: Option[
      Iterable[zio.aws.computeoptimizer.model.InstanceRecommendationOption]
    ] = None,
    recommendationSources: Option[
      Iterable[zio.aws.computeoptimizer.model.RecommendationSource]
    ] = None,
    lastRefreshTimestamp: Option[LastRefreshTimestamp] = None,
    currentPerformanceRisk: Option[
      zio.aws.computeoptimizer.model.CurrentPerformanceRisk
    ] = None,
    effectiveRecommendationPreferences: Option[
      zio.aws.computeoptimizer.model.EffectiveRecommendationPreferences
    ] = None,
    inferredWorkloadTypes: Option[
      Iterable[zio.aws.computeoptimizer.model.InferredWorkloadType]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendation = {
    import InstanceRecommendation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendation
      .builder()
      .optionallyWith(
        instanceArn.map(value => InstanceArn.unwrap(value): java.lang.String)
      )(_.instanceArn)
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        instanceName.map(value => InstanceName.unwrap(value): java.lang.String)
      )(_.instanceName)
      .optionallyWith(
        currentInstanceType.map(value =>
          CurrentInstanceType.unwrap(value): java.lang.String
        )
      )(_.currentInstanceType)
      .optionallyWith(finding.map(value => value.unwrap))(_.finding)
      .optionallyWith(
        findingReasonCodes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.findingReasonCodesWithStrings)
      .optionallyWith(
        utilizationMetrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.utilizationMetrics)
      .optionallyWith(
        lookBackPeriodInDays.map(value =>
          LookBackPeriodInDays.unwrap(value): java.lang.Double
        )
      )(_.lookBackPeriodInDays)
      .optionallyWith(
        recommendationOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recommendationOptions)
      .optionallyWith(
        recommendationSources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recommendationSources)
      .optionallyWith(
        lastRefreshTimestamp.map(value =>
          LastRefreshTimestamp.unwrap(value): Instant
        )
      )(_.lastRefreshTimestamp)
      .optionallyWith(currentPerformanceRisk.map(value => value.unwrap))(
        _.currentPerformanceRisk
      )
      .optionallyWith(
        effectiveRecommendationPreferences.map(value => value.buildAwsValue())
      )(_.effectiveRecommendationPreferences)
      .optionallyWith(
        inferredWorkloadTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.inferredWorkloadTypesWithStrings)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.InstanceRecommendation.ReadOnly =
    zio.aws.computeoptimizer.model.InstanceRecommendation.wrap(buildAwsValue())
}
object InstanceRecommendation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.computeoptimizer.model.InstanceRecommendation =
      zio.aws.computeoptimizer.model.InstanceRecommendation(
        instanceArn.map(value => value),
        accountId.map(value => value),
        instanceName.map(value => value),
        currentInstanceType.map(value => value),
        finding.map(value => value),
        findingReasonCodes.map(value => value),
        utilizationMetrics.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lookBackPeriodInDays.map(value => value),
        recommendationOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        recommendationSources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lastRefreshTimestamp.map(value => value),
        currentPerformanceRisk.map(value => value),
        effectiveRecommendationPreferences.map(value => value.asEditable),
        inferredWorkloadTypes.map(value => value)
      )
    def instanceArn: Option[InstanceArn]
    def accountId: Option[AccountId]
    def instanceName: Option[InstanceName]
    def currentInstanceType: Option[CurrentInstanceType]
    def finding: Option[zio.aws.computeoptimizer.model.Finding]
    def findingReasonCodes: Option[List[
      zio.aws.computeoptimizer.model.InstanceRecommendationFindingReasonCode
    ]]
    def utilizationMetrics: Option[
      List[zio.aws.computeoptimizer.model.UtilizationMetric.ReadOnly]
    ]
    def lookBackPeriodInDays: Option[LookBackPeriodInDays]
    def recommendationOptions: Option[
      List[zio.aws.computeoptimizer.model.InstanceRecommendationOption.ReadOnly]
    ]
    def recommendationSources: Option[
      List[zio.aws.computeoptimizer.model.RecommendationSource.ReadOnly]
    ]
    def lastRefreshTimestamp: Option[LastRefreshTimestamp]
    def currentPerformanceRisk
        : Option[zio.aws.computeoptimizer.model.CurrentPerformanceRisk]
    def effectiveRecommendationPreferences: Option[
      zio.aws.computeoptimizer.model.EffectiveRecommendationPreferences.ReadOnly
    ]
    def inferredWorkloadTypes
        : Option[List[zio.aws.computeoptimizer.model.InferredWorkloadType]]
    def getInstanceArn: ZIO[Any, AwsError, InstanceArn] =
      AwsError.unwrapOptionField("instanceArn", instanceArn)
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getInstanceName: ZIO[Any, AwsError, InstanceName] =
      AwsError.unwrapOptionField("instanceName", instanceName)
    def getCurrentInstanceType: ZIO[Any, AwsError, CurrentInstanceType] =
      AwsError.unwrapOptionField("currentInstanceType", currentInstanceType)
    def getFinding: ZIO[Any, AwsError, zio.aws.computeoptimizer.model.Finding] =
      AwsError.unwrapOptionField("finding", finding)
    def getFindingReasonCodes: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.InstanceRecommendationFindingReasonCode
    ]] = AwsError.unwrapOptionField("findingReasonCodes", findingReasonCodes)
    def getUtilizationMetrics: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.UtilizationMetric.ReadOnly
    ]] = AwsError.unwrapOptionField("utilizationMetrics", utilizationMetrics)
    def getLookBackPeriodInDays: ZIO[Any, AwsError, LookBackPeriodInDays] =
      AwsError.unwrapOptionField("lookBackPeriodInDays", lookBackPeriodInDays)
    def getRecommendationOptions: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.InstanceRecommendationOption.ReadOnly
    ]] =
      AwsError.unwrapOptionField("recommendationOptions", recommendationOptions)
    def getRecommendationSources: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.RecommendationSource.ReadOnly
    ]] =
      AwsError.unwrapOptionField("recommendationSources", recommendationSources)
    def getLastRefreshTimestamp: ZIO[Any, AwsError, LastRefreshTimestamp] =
      AwsError.unwrapOptionField("lastRefreshTimestamp", lastRefreshTimestamp)
    def getCurrentPerformanceRisk: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.CurrentPerformanceRisk
    ] = AwsError.unwrapOptionField(
      "currentPerformanceRisk",
      currentPerformanceRisk
    )
    def getEffectiveRecommendationPreferences: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.EffectiveRecommendationPreferences.ReadOnly
    ] = AwsError.unwrapOptionField(
      "effectiveRecommendationPreferences",
      effectiveRecommendationPreferences
    )
    def getInferredWorkloadTypes: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.InferredWorkloadType
    ]] =
      AwsError.unwrapOptionField("inferredWorkloadTypes", inferredWorkloadTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendation
  ) extends zio.aws.computeoptimizer.model.InstanceRecommendation.ReadOnly {
    override val instanceArn: Option[InstanceArn] = scala
      .Option(impl.instanceArn())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.InstanceArn(value)
      )
    override val accountId: Option[AccountId] = scala
      .Option(impl.accountId())
      .map(value => zio.aws.computeoptimizer.model.primitives.AccountId(value))
    override val instanceName: Option[InstanceName] = scala
      .Option(impl.instanceName())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.InstanceName(value)
      )
    override val currentInstanceType: Option[CurrentInstanceType] = scala
      .Option(impl.currentInstanceType())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.CurrentInstanceType(value)
      )
    override val finding: Option[zio.aws.computeoptimizer.model.Finding] = scala
      .Option(impl.finding())
      .map(value => zio.aws.computeoptimizer.model.Finding.wrap(value))
    override val findingReasonCodes: Option[List[
      zio.aws.computeoptimizer.model.InstanceRecommendationFindingReasonCode
    ]] = scala
      .Option(impl.findingReasonCodes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.InstanceRecommendationFindingReasonCode
            .wrap(item)
        }.toList
      )
    override val utilizationMetrics: Option[
      List[zio.aws.computeoptimizer.model.UtilizationMetric.ReadOnly]
    ] = scala
      .Option(impl.utilizationMetrics())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.UtilizationMetric.wrap(item)
        }.toList
      )
    override val lookBackPeriodInDays: Option[LookBackPeriodInDays] = scala
      .Option(impl.lookBackPeriodInDays())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.LookBackPeriodInDays(value)
      )
    override val recommendationOptions: Option[
      List[zio.aws.computeoptimizer.model.InstanceRecommendationOption.ReadOnly]
    ] = scala
      .Option(impl.recommendationOptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.InstanceRecommendationOption.wrap(item)
        }.toList
      )
    override val recommendationSources: Option[
      List[zio.aws.computeoptimizer.model.RecommendationSource.ReadOnly]
    ] = scala
      .Option(impl.recommendationSources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.RecommendationSource.wrap(item)
        }.toList
      )
    override val lastRefreshTimestamp: Option[LastRefreshTimestamp] = scala
      .Option(impl.lastRefreshTimestamp())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.LastRefreshTimestamp(value)
      )
    override val currentPerformanceRisk
        : Option[zio.aws.computeoptimizer.model.CurrentPerformanceRisk] = scala
      .Option(impl.currentPerformanceRisk())
      .map(value =>
        zio.aws.computeoptimizer.model.CurrentPerformanceRisk.wrap(value)
      )
    override val effectiveRecommendationPreferences: Option[
      zio.aws.computeoptimizer.model.EffectiveRecommendationPreferences.ReadOnly
    ] = scala
      .Option(impl.effectiveRecommendationPreferences())
      .map(value =>
        zio.aws.computeoptimizer.model.EffectiveRecommendationPreferences
          .wrap(value)
      )
    override val inferredWorkloadTypes
        : Option[List[zio.aws.computeoptimizer.model.InferredWorkloadType]] =
      scala
        .Option(impl.inferredWorkloadTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.computeoptimizer.model.InferredWorkloadType.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendation
  ): zio.aws.computeoptimizer.model.InstanceRecommendation.ReadOnly =
    new Wrapper(impl)
}
