package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.computeoptimizer.model.primitives.{
  IncludeMemberAccounts,
  AccountId
}
import scala.jdk.CollectionConverters._
final case class ExportLambdaFunctionRecommendationsRequest(
    accountIds: Option[Iterable[AccountId]] = None,
    filters: Option[Iterable[
      zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFilter
    ]] = None,
    fieldsToExport: Option[
      Iterable[zio.aws.computeoptimizer.model.ExportableLambdaFunctionField]
    ] = None,
    s3DestinationConfig: zio.aws.computeoptimizer.model.S3DestinationConfig,
    fileFormat: Option[zio.aws.computeoptimizer.model.FileFormat] = None,
    includeMemberAccounts: Option[IncludeMemberAccounts] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.ExportLambdaFunctionRecommendationsRequest = {
    import ExportLambdaFunctionRecommendationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.ExportLambdaFunctionRecommendationsRequest
      .builder()
      .optionallyWith(
        accountIds.map(value =>
          value.map { item =>
            AccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.accountIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        fieldsToExport.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.fieldsToExportWithStrings)
      .s3DestinationConfig(s3DestinationConfig.buildAwsValue())
      .optionallyWith(fileFormat.map(value => value.unwrap))(_.fileFormat)
      .optionallyWith(
        includeMemberAccounts.map(value =>
          IncludeMemberAccounts.unwrap(value): java.lang.Boolean
        )
      )(_.includeMemberAccounts)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.ExportLambdaFunctionRecommendationsRequest.ReadOnly =
    zio.aws.computeoptimizer.model.ExportLambdaFunctionRecommendationsRequest
      .wrap(buildAwsValue())
}
object ExportLambdaFunctionRecommendationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.ExportLambdaFunctionRecommendationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.ExportLambdaFunctionRecommendationsRequest =
      zio.aws.computeoptimizer.model.ExportLambdaFunctionRecommendationsRequest(
        accountIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        fieldsToExport.map(value => value),
        s3DestinationConfig.asEditable,
        fileFormat.map(value => value),
        includeMemberAccounts.map(value => value)
      )
    def accountIds: Option[List[AccountId]]
    def filters: Option[List[
      zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFilter.ReadOnly
    ]]
    def fieldsToExport: Option[
      List[zio.aws.computeoptimizer.model.ExportableLambdaFunctionField]
    ]
    def s3DestinationConfig
        : zio.aws.computeoptimizer.model.S3DestinationConfig.ReadOnly
    def fileFormat: Option[zio.aws.computeoptimizer.model.FileFormat]
    def includeMemberAccounts: Option[IncludeMemberAccounts]
    def getAccountIds: ZIO[Any, AwsError, List[AccountId]] =
      AwsError.unwrapOptionField("accountIds", accountIds)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getFieldsToExport: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.ExportableLambdaFunctionField
    ]] = AwsError.unwrapOptionField("fieldsToExport", fieldsToExport)
    def getS3DestinationConfig: ZIO[
      Any,
      Nothing,
      zio.aws.computeoptimizer.model.S3DestinationConfig.ReadOnly
    ] = ZIO.succeed(s3DestinationConfig)
    def getFileFormat
        : ZIO[Any, AwsError, zio.aws.computeoptimizer.model.FileFormat] =
      AwsError.unwrapOptionField("fileFormat", fileFormat)
    def getIncludeMemberAccounts: ZIO[Any, AwsError, IncludeMemberAccounts] =
      AwsError.unwrapOptionField("includeMemberAccounts", includeMemberAccounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.ExportLambdaFunctionRecommendationsRequest
  ) extends zio.aws.computeoptimizer.model.ExportLambdaFunctionRecommendationsRequest.ReadOnly {
    override val accountIds: Option[List[AccountId]] = scala
      .Option(impl.accountIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.primitives.AccountId(item)
        }.toList
      )
    override val filters: Option[List[
      zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFilter.ReadOnly
    ]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFilter
            .wrap(item)
        }.toList
      )
    override val fieldsToExport: Option[
      List[zio.aws.computeoptimizer.model.ExportableLambdaFunctionField]
    ] = scala
      .Option(impl.fieldsToExport())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.ExportableLambdaFunctionField
            .wrap(item)
        }.toList
      )
    override val s3DestinationConfig
        : zio.aws.computeoptimizer.model.S3DestinationConfig.ReadOnly =
      zio.aws.computeoptimizer.model.S3DestinationConfig
        .wrap(impl.s3DestinationConfig())
    override val fileFormat: Option[zio.aws.computeoptimizer.model.FileFormat] =
      scala
        .Option(impl.fileFormat())
        .map(value => zio.aws.computeoptimizer.model.FileFormat.wrap(value))
    override val includeMemberAccounts: Option[IncludeMemberAccounts] = scala
      .Option(impl.includeMemberAccounts())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.IncludeMemberAccounts(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.ExportLambdaFunctionRecommendationsRequest
  ): zio.aws.computeoptimizer.model.ExportLambdaFunctionRecommendationsRequest.ReadOnly =
    new Wrapper(impl)
}
