package zio.aws.computeoptimizer.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.computeoptimizer.model.primitives.{MaxResults, NextToken}
import scala.jdk.CollectionConverters._
final case class GetEnrollmentStatusesForOrganizationRequest(
    filters: Option[Iterable[zio.aws.computeoptimizer.model.EnrollmentFilter]] =
      None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.GetEnrollmentStatusesForOrganizationRequest = {
    import GetEnrollmentStatusesForOrganizationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.GetEnrollmentStatusesForOrganizationRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.GetEnrollmentStatusesForOrganizationRequest.ReadOnly =
    zio.aws.computeoptimizer.model.GetEnrollmentStatusesForOrganizationRequest
      .wrap(buildAwsValue())
}
object GetEnrollmentStatusesForOrganizationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.GetEnrollmentStatusesForOrganizationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.GetEnrollmentStatusesForOrganizationRequest =
      zio.aws.computeoptimizer.model
        .GetEnrollmentStatusesForOrganizationRequest(
          filters.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          nextToken.map(value => value),
          maxResults.map(value => value)
        )
    def filters
        : Option[List[zio.aws.computeoptimizer.model.EnrollmentFilter.ReadOnly]]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.EnrollmentFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetEnrollmentStatusesForOrganizationRequest
  ) extends zio.aws.computeoptimizer.model.GetEnrollmentStatusesForOrganizationRequest.ReadOnly {
    override val filters: Option[
      List[zio.aws.computeoptimizer.model.EnrollmentFilter.ReadOnly]
    ] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.EnrollmentFilter.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.computeoptimizer.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.computeoptimizer.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetEnrollmentStatusesForOrganizationRequest
  ): zio.aws.computeoptimizer.model.GetEnrollmentStatusesForOrganizationRequest.ReadOnly =
    new Wrapper(impl)
}
