package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutRecommendationPreferencesRequest(
    resourceType: zio.aws.computeoptimizer.model.ResourceType,
    scope: Option[zio.aws.computeoptimizer.model.Scope] = None,
    enhancedInfrastructureMetrics: Option[
      zio.aws.computeoptimizer.model.EnhancedInfrastructureMetrics
    ] = None,
    inferredWorkloadTypes: Option[
      zio.aws.computeoptimizer.model.InferredWorkloadTypesPreference
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.PutRecommendationPreferencesRequest = {
    import PutRecommendationPreferencesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.PutRecommendationPreferencesRequest
      .builder()
      .resourceType(resourceType.unwrap)
      .optionallyWith(scope.map(value => value.buildAwsValue()))(_.scope)
      .optionallyWith(enhancedInfrastructureMetrics.map(value => value.unwrap))(
        _.enhancedInfrastructureMetrics
      )
      .optionallyWith(inferredWorkloadTypes.map(value => value.unwrap))(
        _.inferredWorkloadTypes
      )
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.PutRecommendationPreferencesRequest.ReadOnly =
    zio.aws.computeoptimizer.model.PutRecommendationPreferencesRequest
      .wrap(buildAwsValue())
}
object PutRecommendationPreferencesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.PutRecommendationPreferencesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.PutRecommendationPreferencesRequest =
      zio.aws.computeoptimizer.model.PutRecommendationPreferencesRequest(
        resourceType,
        scope.map(value => value.asEditable),
        enhancedInfrastructureMetrics.map(value => value),
        inferredWorkloadTypes.map(value => value)
      )
    def resourceType: zio.aws.computeoptimizer.model.ResourceType
    def scope: Option[zio.aws.computeoptimizer.model.Scope.ReadOnly]
    def enhancedInfrastructureMetrics
        : Option[zio.aws.computeoptimizer.model.EnhancedInfrastructureMetrics]
    def inferredWorkloadTypes
        : Option[zio.aws.computeoptimizer.model.InferredWorkloadTypesPreference]
    def getResourceType
        : ZIO[Any, Nothing, zio.aws.computeoptimizer.model.ResourceType] =
      ZIO.succeed(resourceType)
    def getScope
        : ZIO[Any, AwsError, zio.aws.computeoptimizer.model.Scope.ReadOnly] =
      AwsError.unwrapOptionField("scope", scope)
    def getEnhancedInfrastructureMetrics: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.EnhancedInfrastructureMetrics
    ] = AwsError.unwrapOptionField(
      "enhancedInfrastructureMetrics",
      enhancedInfrastructureMetrics
    )
    def getInferredWorkloadTypes: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.InferredWorkloadTypesPreference
    ] =
      AwsError.unwrapOptionField("inferredWorkloadTypes", inferredWorkloadTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.PutRecommendationPreferencesRequest
  ) extends zio.aws.computeoptimizer.model.PutRecommendationPreferencesRequest.ReadOnly {
    override val resourceType: zio.aws.computeoptimizer.model.ResourceType =
      zio.aws.computeoptimizer.model.ResourceType.wrap(impl.resourceType())
    override val scope: Option[zio.aws.computeoptimizer.model.Scope.ReadOnly] =
      scala
        .Option(impl.scope())
        .map(value => zio.aws.computeoptimizer.model.Scope.wrap(value))
    override val enhancedInfrastructureMetrics
        : Option[zio.aws.computeoptimizer.model.EnhancedInfrastructureMetrics] =
      scala
        .Option(impl.enhancedInfrastructureMetrics())
        .map(value =>
          zio.aws.computeoptimizer.model.EnhancedInfrastructureMetrics
            .wrap(value)
        )
    override val inferredWorkloadTypes: Option[
      zio.aws.computeoptimizer.model.InferredWorkloadTypesPreference
    ] = scala
      .Option(impl.inferredWorkloadTypes())
      .map(value =>
        zio.aws.computeoptimizer.model.InferredWorkloadTypesPreference
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.PutRecommendationPreferencesRequest
  ): zio.aws.computeoptimizer.model.PutRecommendationPreferencesRequest.ReadOnly =
    new Wrapper(impl)
}
