package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters._
sealed trait LambdaFunctionRecommendationFinding {
  def unwrap: software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendationFinding
}
object LambdaFunctionRecommendationFinding {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendationFinding
  ): zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFinding =
    value match {
      case software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendationFinding.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendationFinding.OPTIMIZED =>
        val r = Optimized
        r
      case software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendationFinding.NOT_OPTIMIZED =>
        val r = NotOptimized
        r
      case software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendationFinding.UNAVAILABLE =>
        val r = Unavailable
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFinding {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendationFinding =
      software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendationFinding.UNKNOWN_TO_SDK_VERSION
  }
  case object Optimized
      extends zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFinding {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendationFinding =
      software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendationFinding.OPTIMIZED
  }
  case object NotOptimized
      extends zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFinding {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendationFinding =
      software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendationFinding.NOT_OPTIMIZED
  }
  case object Unavailable
      extends zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFinding {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendationFinding =
      software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendationFinding.UNAVAILABLE
  }
}
