package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.computeoptimizer.model.primitives.ScopeValue
import scala.jdk.CollectionConverters._
final case class Scope(
    name: Option[zio.aws.computeoptimizer.model.ScopeName] = None,
    value: Option[ScopeValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.Scope = {
    import Scope.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.Scope
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(
        value.map(value => ScopeValue.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.computeoptimizer.model.Scope.ReadOnly =
    zio.aws.computeoptimizer.model.Scope.wrap(buildAwsValue())
}
object Scope {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.Scope
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.computeoptimizer.model.Scope =
      zio.aws.computeoptimizer.model
        .Scope(name.map(value => value), value.map(value => value))
    def name: Option[zio.aws.computeoptimizer.model.ScopeName]
    def value: Option[ScopeValue]
    def getName: ZIO[Any, AwsError, zio.aws.computeoptimizer.model.ScopeName] =
      AwsError.unwrapOptionField("name", name)
    def getValue: ZIO[Any, AwsError, ScopeValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.Scope
  ) extends zio.aws.computeoptimizer.model.Scope.ReadOnly {
    override val name: Option[zio.aws.computeoptimizer.model.ScopeName] = scala
      .Option(impl.name())
      .map(value => zio.aws.computeoptimizer.model.ScopeName.wrap(value))
    override val value: Option[ScopeValue] = scala
      .Option(impl.value())
      .map(value => zio.aws.computeoptimizer.model.primitives.ScopeValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.Scope
  ): zio.aws.computeoptimizer.model.Scope.ReadOnly = new Wrapper(impl)
}
