package zio.aws.computeoptimizer.model
import zio.aws.computeoptimizer.model.primitives.{
  NumberOfMemberAccountsOptedIn,
  LastUpdatedTimestamp,
  MemberAccountsEnrolled,
  StatusReason
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetEnrollmentStatusResponse(
    status: Option[zio.aws.computeoptimizer.model.Status] = None,
    statusReason: Option[StatusReason] = None,
    memberAccountsEnrolled: Option[MemberAccountsEnrolled] = None,
    lastUpdatedTimestamp: Option[LastUpdatedTimestamp] = None,
    numberOfMemberAccountsOptedIn: Option[NumberOfMemberAccountsOptedIn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.GetEnrollmentStatusResponse = {
    import GetEnrollmentStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.GetEnrollmentStatusResponse
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusReason.map(value => StatusReason.unwrap(value): java.lang.String)
      )(_.statusReason)
      .optionallyWith(
        memberAccountsEnrolled.map(value =>
          MemberAccountsEnrolled.unwrap(value): java.lang.Boolean
        )
      )(_.memberAccountsEnrolled)
      .optionallyWith(
        lastUpdatedTimestamp.map(value =>
          LastUpdatedTimestamp.unwrap(value): Instant
        )
      )(_.lastUpdatedTimestamp)
      .optionallyWith(
        numberOfMemberAccountsOptedIn.map(value =>
          NumberOfMemberAccountsOptedIn.unwrap(value): Integer
        )
      )(_.numberOfMemberAccountsOptedIn)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.GetEnrollmentStatusResponse.ReadOnly =
    zio.aws.computeoptimizer.model.GetEnrollmentStatusResponse
      .wrap(buildAwsValue())
}
object GetEnrollmentStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.GetEnrollmentStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.computeoptimizer.model.GetEnrollmentStatusResponse =
      zio.aws.computeoptimizer.model.GetEnrollmentStatusResponse(
        status.map(value => value),
        statusReason.map(value => value),
        memberAccountsEnrolled.map(value => value),
        lastUpdatedTimestamp.map(value => value),
        numberOfMemberAccountsOptedIn.map(value => value)
      )
    def status: Option[zio.aws.computeoptimizer.model.Status]
    def statusReason: Option[StatusReason]
    def memberAccountsEnrolled: Option[MemberAccountsEnrolled]
    def lastUpdatedTimestamp: Option[LastUpdatedTimestamp]
    def numberOfMemberAccountsOptedIn: Option[NumberOfMemberAccountsOptedIn]
    def getStatus: ZIO[Any, AwsError, zio.aws.computeoptimizer.model.Status] =
      AwsError.unwrapOptionField("status", status)
    def getStatusReason: ZIO[Any, AwsError, StatusReason] =
      AwsError.unwrapOptionField("statusReason", statusReason)
    def getMemberAccountsEnrolled: ZIO[Any, AwsError, MemberAccountsEnrolled] =
      AwsError.unwrapOptionField(
        "memberAccountsEnrolled",
        memberAccountsEnrolled
      )
    def getLastUpdatedTimestamp: ZIO[Any, AwsError, LastUpdatedTimestamp] =
      AwsError.unwrapOptionField("lastUpdatedTimestamp", lastUpdatedTimestamp)
    def getNumberOfMemberAccountsOptedIn
        : ZIO[Any, AwsError, NumberOfMemberAccountsOptedIn] =
      AwsError.unwrapOptionField(
        "numberOfMemberAccountsOptedIn",
        numberOfMemberAccountsOptedIn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetEnrollmentStatusResponse
  ) extends zio.aws.computeoptimizer.model.GetEnrollmentStatusResponse.ReadOnly {
    override val status: Option[zio.aws.computeoptimizer.model.Status] = scala
      .Option(impl.status())
      .map(value => zio.aws.computeoptimizer.model.Status.wrap(value))
    override val statusReason: Option[StatusReason] = scala
      .Option(impl.statusReason())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.StatusReason(value)
      )
    override val memberAccountsEnrolled: Option[MemberAccountsEnrolled] = scala
      .Option(impl.memberAccountsEnrolled())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.MemberAccountsEnrolled(value)
      )
    override val lastUpdatedTimestamp: Option[LastUpdatedTimestamp] = scala
      .Option(impl.lastUpdatedTimestamp())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.LastUpdatedTimestamp(value)
      )
    override val numberOfMemberAccountsOptedIn
        : Option[NumberOfMemberAccountsOptedIn] = scala
      .Option(impl.numberOfMemberAccountsOptedIn())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives
          .NumberOfMemberAccountsOptedIn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetEnrollmentStatusResponse
  ): zio.aws.computeoptimizer.model.GetEnrollmentStatusResponse.ReadOnly =
    new Wrapper(impl)
}
