package zio.aws.computeoptimizer.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.computeoptimizer.model.primitives.{
  MaxResults,
  NextToken,
  AutoScalingGroupArn,
  AccountId
}
import scala.jdk.CollectionConverters._
final case class GetAutoScalingGroupRecommendationsRequest(
    accountIds: Option[Iterable[AccountId]] = None,
    autoScalingGroupArns: Option[Iterable[AutoScalingGroupArn]] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None,
    filters: Option[Iterable[zio.aws.computeoptimizer.model.Filter]] = None,
    recommendationPreferences: Option[
      zio.aws.computeoptimizer.model.RecommendationPreferences
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.GetAutoScalingGroupRecommendationsRequest = {
    import GetAutoScalingGroupRecommendationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.GetAutoScalingGroupRecommendationsRequest
      .builder()
      .optionallyWith(
        accountIds.map(value =>
          value.map { item =>
            AccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.accountIds)
      .optionallyWith(
        autoScalingGroupArns.map(value =>
          value.map { item =>
            AutoScalingGroupArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.autoScalingGroupArns)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        recommendationPreferences.map(value => value.buildAwsValue())
      )(_.recommendationPreferences)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.GetAutoScalingGroupRecommendationsRequest.ReadOnly =
    zio.aws.computeoptimizer.model.GetAutoScalingGroupRecommendationsRequest
      .wrap(buildAwsValue())
}
object GetAutoScalingGroupRecommendationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.GetAutoScalingGroupRecommendationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.GetAutoScalingGroupRecommendationsRequest =
      zio.aws.computeoptimizer.model.GetAutoScalingGroupRecommendationsRequest(
        accountIds.map(value => value),
        autoScalingGroupArns.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        recommendationPreferences.map(value => value.asEditable)
      )
    def accountIds: Option[List[AccountId]]
    def autoScalingGroupArns: Option[List[AutoScalingGroupArn]]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def filters: Option[List[zio.aws.computeoptimizer.model.Filter.ReadOnly]]
    def recommendationPreferences: Option[
      zio.aws.computeoptimizer.model.RecommendationPreferences.ReadOnly
    ]
    def getAccountIds: ZIO[Any, AwsError, List[AccountId]] =
      AwsError.unwrapOptionField("accountIds", accountIds)
    def getAutoScalingGroupArns: ZIO[Any, AwsError, List[AutoScalingGroupArn]] =
      AwsError.unwrapOptionField("autoScalingGroupArns", autoScalingGroupArns)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.Filter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getRecommendationPreferences: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.RecommendationPreferences.ReadOnly
    ] = AwsError.unwrapOptionField(
      "recommendationPreferences",
      recommendationPreferences
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetAutoScalingGroupRecommendationsRequest
  ) extends zio.aws.computeoptimizer.model.GetAutoScalingGroupRecommendationsRequest.ReadOnly {
    override val accountIds: Option[List[AccountId]] = scala
      .Option(impl.accountIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.primitives.AccountId(item)
        }.toList
      )
    override val autoScalingGroupArns: Option[List[AutoScalingGroupArn]] = scala
      .Option(impl.autoScalingGroupArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.primitives.AutoScalingGroupArn(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.computeoptimizer.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.computeoptimizer.model.primitives.MaxResults(value))
    override val filters
        : Option[List[zio.aws.computeoptimizer.model.Filter.ReadOnly]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.Filter.wrap(item)
        }.toList
      )
    override val recommendationPreferences: Option[
      zio.aws.computeoptimizer.model.RecommendationPreferences.ReadOnly
    ] = scala
      .Option(impl.recommendationPreferences())
      .map(value =>
        zio.aws.computeoptimizer.model.RecommendationPreferences.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetAutoScalingGroupRecommendationsRequest
  ): zio.aws.computeoptimizer.model.GetAutoScalingGroupRecommendationsRequest.ReadOnly =
    new Wrapper(impl)
}
