package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.computeoptimizer.model.primitives.RecommendationSourceArn
import scala.jdk.CollectionConverters._
final case class RecommendationSource(
    recommendationSourceArn: Option[RecommendationSourceArn] = None,
    recommendationSourceType: Option[
      zio.aws.computeoptimizer.model.RecommendationSourceType
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.RecommendationSource = {
    import RecommendationSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.RecommendationSource
      .builder()
      .optionallyWith(
        recommendationSourceArn.map(value =>
          RecommendationSourceArn.unwrap(value): java.lang.String
        )
      )(_.recommendationSourceArn)
      .optionallyWith(recommendationSourceType.map(value => value.unwrap))(
        _.recommendationSourceType
      )
      .build()
  }
  def asReadOnly: zio.aws.computeoptimizer.model.RecommendationSource.ReadOnly =
    zio.aws.computeoptimizer.model.RecommendationSource.wrap(buildAwsValue())
}
object RecommendationSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.RecommendationSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.computeoptimizer.model.RecommendationSource =
      zio.aws.computeoptimizer.model.RecommendationSource(
        recommendationSourceArn.map(value => value),
        recommendationSourceType.map(value => value)
      )
    def recommendationSourceArn: Option[RecommendationSourceArn]
    def recommendationSourceType
        : Option[zio.aws.computeoptimizer.model.RecommendationSourceType]
    def getRecommendationSourceArn
        : ZIO[Any, AwsError, RecommendationSourceArn] = AwsError
      .unwrapOptionField("recommendationSourceArn", recommendationSourceArn)
    def getRecommendationSourceType: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.RecommendationSourceType
    ] = AwsError.unwrapOptionField(
      "recommendationSourceType",
      recommendationSourceType
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.RecommendationSource
  ) extends zio.aws.computeoptimizer.model.RecommendationSource.ReadOnly {
    override val recommendationSourceArn: Option[RecommendationSourceArn] =
      scala
        .Option(impl.recommendationSourceArn())
        .map(value =>
          zio.aws.computeoptimizer.model.primitives
            .RecommendationSourceArn(value)
        )
    override val recommendationSourceType
        : Option[zio.aws.computeoptimizer.model.RecommendationSourceType] =
      scala
        .Option(impl.recommendationSourceType())
        .map(value =>
          zio.aws.computeoptimizer.model.RecommendationSourceType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.RecommendationSource
  ): zio.aws.computeoptimizer.model.RecommendationSource.ReadOnly = new Wrapper(
    impl
  )
}
