package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.computeoptimizer.model.primitives.FilterValue
import scala.jdk.CollectionConverters._
final case class LambdaFunctionRecommendationFilter(
    name: Option[
      zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFilterName
    ] = None,
    values: Option[Iterable[FilterValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendationFilter = {
    import LambdaFunctionRecommendationFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendationFilter
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            FilterValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFilter.ReadOnly =
    zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFilter
      .wrap(buildAwsValue())
}
object LambdaFunctionRecommendationFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendationFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFilter =
      zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFilter(
        name.map(value => value),
        values.map(value => value)
      )
    def name: Option[
      zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFilterName
    ]
    def values: Option[List[FilterValue]]
    def getName: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFilterName
    ] = AwsError.unwrapOptionField("name", name)
    def getValues: ZIO[Any, AwsError, List[FilterValue]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendationFilter
  ) extends zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFilter.ReadOnly {
    override val name: Option[
      zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFilterName
    ] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFilterName
          .wrap(value)
      )
    override val values: Option[List[FilterValue]] = scala
      .Option(impl.values())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.primitives.FilterValue(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendationFilter
  ): zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFilter.ReadOnly =
    new Wrapper(impl)
}
