package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetEc2RecommendationProjectedMetricsResponse(
    recommendedOptionProjectedMetrics: Option[
      Iterable[zio.aws.computeoptimizer.model.RecommendedOptionProjectedMetric]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.GetEc2RecommendationProjectedMetricsResponse = {
    import GetEc2RecommendationProjectedMetricsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.GetEc2RecommendationProjectedMetricsResponse
      .builder()
      .optionallyWith(
        recommendedOptionProjectedMetrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recommendedOptionProjectedMetrics)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.GetEc2RecommendationProjectedMetricsResponse.ReadOnly =
    zio.aws.computeoptimizer.model.GetEc2RecommendationProjectedMetricsResponse
      .wrap(buildAwsValue())
}
object GetEc2RecommendationProjectedMetricsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.GetEc2RecommendationProjectedMetricsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.GetEc2RecommendationProjectedMetricsResponse =
      zio.aws.computeoptimizer.model
        .GetEc2RecommendationProjectedMetricsResponse(
          recommendedOptionProjectedMetrics.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def recommendedOptionProjectedMetrics: Option[List[
      zio.aws.computeoptimizer.model.RecommendedOptionProjectedMetric.ReadOnly
    ]]
    def getRecommendedOptionProjectedMetrics: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.RecommendedOptionProjectedMetric.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "recommendedOptionProjectedMetrics",
      recommendedOptionProjectedMetrics
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetEc2RecommendationProjectedMetricsResponse
  ) extends zio.aws.computeoptimizer.model.GetEc2RecommendationProjectedMetricsResponse.ReadOnly {
    override val recommendedOptionProjectedMetrics: Option[List[
      zio.aws.computeoptimizer.model.RecommendedOptionProjectedMetric.ReadOnly
    ]] = scala
      .Option(impl.recommendedOptionProjectedMetrics())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.RecommendedOptionProjectedMetric
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetEc2RecommendationProjectedMetricsResponse
  ): zio.aws.computeoptimizer.model.GetEc2RecommendationProjectedMetricsResponse.ReadOnly =
    new Wrapper(impl)
}
