package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.computeoptimizer.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class GetRecommendationPreferencesResponse(
    nextToken: Option[NextToken] = None,
    recommendationPreferencesDetails: Option[
      Iterable[zio.aws.computeoptimizer.model.RecommendationPreferencesDetail]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationPreferencesResponse = {
    import GetRecommendationPreferencesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationPreferencesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        recommendationPreferencesDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recommendationPreferencesDetails)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.GetRecommendationPreferencesResponse.ReadOnly =
    zio.aws.computeoptimizer.model.GetRecommendationPreferencesResponse
      .wrap(buildAwsValue())
}
object GetRecommendationPreferencesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationPreferencesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.GetRecommendationPreferencesResponse =
      zio.aws.computeoptimizer.model.GetRecommendationPreferencesResponse(
        nextToken.map(value => value),
        recommendationPreferencesDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextToken]
    def recommendationPreferencesDetails: Option[List[
      zio.aws.computeoptimizer.model.RecommendationPreferencesDetail.ReadOnly
    ]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRecommendationPreferencesDetails: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.RecommendationPreferencesDetail.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "recommendationPreferencesDetails",
      recommendationPreferencesDetails
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationPreferencesResponse
  ) extends zio.aws.computeoptimizer.model.GetRecommendationPreferencesResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.computeoptimizer.model.primitives.NextToken(value))
    override val recommendationPreferencesDetails: Option[List[
      zio.aws.computeoptimizer.model.RecommendationPreferencesDetail.ReadOnly
    ]] = scala
      .Option(impl.recommendationPreferencesDetails())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.RecommendationPreferencesDetail
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationPreferencesResponse
  ): zio.aws.computeoptimizer.model.GetRecommendationPreferencesResponse.ReadOnly =
    new Wrapper(impl)
}
