package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.computeoptimizer.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class DescribeRecommendationExportJobsResponse(
    recommendationExportJobs: Option[
      Iterable[zio.aws.computeoptimizer.model.RecommendationExportJob]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.DescribeRecommendationExportJobsResponse = {
    import DescribeRecommendationExportJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.DescribeRecommendationExportJobsResponse
      .builder()
      .optionallyWith(
        recommendationExportJobs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recommendationExportJobs)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.DescribeRecommendationExportJobsResponse.ReadOnly =
    zio.aws.computeoptimizer.model.DescribeRecommendationExportJobsResponse
      .wrap(buildAwsValue())
}
object DescribeRecommendationExportJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.DescribeRecommendationExportJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.DescribeRecommendationExportJobsResponse =
      zio.aws.computeoptimizer.model.DescribeRecommendationExportJobsResponse(
        recommendationExportJobs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def recommendationExportJobs: Option[
      List[zio.aws.computeoptimizer.model.RecommendationExportJob.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def getRecommendationExportJobs: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.RecommendationExportJob.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "recommendationExportJobs",
      recommendationExportJobs
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.DescribeRecommendationExportJobsResponse
  ) extends zio.aws.computeoptimizer.model.DescribeRecommendationExportJobsResponse.ReadOnly {
    override val recommendationExportJobs: Option[
      List[zio.aws.computeoptimizer.model.RecommendationExportJob.ReadOnly]
    ] = scala
      .Option(impl.recommendationExportJobs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.RecommendationExportJob.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.computeoptimizer.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.DescribeRecommendationExportJobsResponse
  ): zio.aws.computeoptimizer.model.DescribeRecommendationExportJobsResponse.ReadOnly =
    new Wrapper(impl)
}
