package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters._
sealed trait ExportableAutoScalingGroupField {
  def unwrap: software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField
}
object ExportableAutoScalingGroupField {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField
  ): zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField =
    value match {
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.ACCOUNT_ID =>
        val r = AccountId
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.AUTO_SCALING_GROUP_ARN =>
        val r = AutoScalingGroupArn
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.AUTO_SCALING_GROUP_NAME =>
        val r = AutoScalingGroupName
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.FINDING =>
        val r = Finding
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.UTILIZATION_METRICS_CPU_MAXIMUM =>
        val r = UtilizationMetricsCpuMaximum
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.UTILIZATION_METRICS_MEMORY_MAXIMUM =>
        val r = UtilizationMetricsMemoryMaximum
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.UTILIZATION_METRICS_EBS_READ_OPS_PER_SECOND_MAXIMUM =>
        val r = UtilizationMetricsEbsReadOpsPerSecondMaximum
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.UTILIZATION_METRICS_EBS_WRITE_OPS_PER_SECOND_MAXIMUM =>
        val r = UtilizationMetricsEbsWriteOpsPerSecondMaximum
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.UTILIZATION_METRICS_EBS_READ_BYTES_PER_SECOND_MAXIMUM =>
        val r = UtilizationMetricsEbsReadBytesPerSecondMaximum
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.UTILIZATION_METRICS_EBS_WRITE_BYTES_PER_SECOND_MAXIMUM =>
        val r = UtilizationMetricsEbsWriteBytesPerSecondMaximum
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.UTILIZATION_METRICS_DISK_READ_OPS_PER_SECOND_MAXIMUM =>
        val r = UtilizationMetricsDiskReadOpsPerSecondMaximum
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.UTILIZATION_METRICS_DISK_WRITE_OPS_PER_SECOND_MAXIMUM =>
        val r = UtilizationMetricsDiskWriteOpsPerSecondMaximum
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.UTILIZATION_METRICS_DISK_READ_BYTES_PER_SECOND_MAXIMUM =>
        val r = UtilizationMetricsDiskReadBytesPerSecondMaximum
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.UTILIZATION_METRICS_DISK_WRITE_BYTES_PER_SECOND_MAXIMUM =>
        val r = UtilizationMetricsDiskWriteBytesPerSecondMaximum
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.UTILIZATION_METRICS_NETWORK_IN_BYTES_PER_SECOND_MAXIMUM =>
        val r = UtilizationMetricsNetworkInBytesPerSecondMaximum
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.UTILIZATION_METRICS_NETWORK_OUT_BYTES_PER_SECOND_MAXIMUM =>
        val r = UtilizationMetricsNetworkOutBytesPerSecondMaximum
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.UTILIZATION_METRICS_NETWORK_PACKETS_IN_PER_SECOND_MAXIMUM =>
        val r = UtilizationMetricsNetworkPacketsInPerSecondMaximum
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.UTILIZATION_METRICS_NETWORK_PACKETS_OUT_PER_SECOND_MAXIMUM =>
        val r = UtilizationMetricsNetworkPacketsOutPerSecondMaximum
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.LOOKBACK_PERIOD_IN_DAYS =>
        val r = LookbackPeriodInDays
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.CURRENT_CONFIGURATION_INSTANCE_TYPE =>
        val r = CurrentConfigurationInstanceType
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.CURRENT_CONFIGURATION_DESIRED_CAPACITY =>
        val r = CurrentConfigurationDesiredCapacity
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.CURRENT_CONFIGURATION_MIN_SIZE =>
        val r = CurrentConfigurationMinSize
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.CURRENT_CONFIGURATION_MAX_SIZE =>
        val r = CurrentConfigurationMaxSize
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.CURRENT_ON_DEMAND_PRICE =>
        val r = CurrentOnDemandPrice
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.CURRENT_STANDARD_ONE_YEAR_NO_UPFRONT_RESERVED_PRICE =>
        val r = CurrentStandardOneYearNoUpfrontReservedPrice
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.CURRENT_STANDARD_THREE_YEAR_NO_UPFRONT_RESERVED_PRICE =>
        val r = CurrentStandardThreeYearNoUpfrontReservedPrice
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.CURRENT_V_CPUS =>
        val r = CurrentVCpus
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.CURRENT_MEMORY =>
        val r = CurrentMemory
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.CURRENT_STORAGE =>
        val r = CurrentStorage
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.CURRENT_NETWORK =>
        val r = CurrentNetwork
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.RECOMMENDATION_OPTIONS_CONFIGURATION_INSTANCE_TYPE =>
        val r = RecommendationOptionsConfigurationInstanceType
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.RECOMMENDATION_OPTIONS_CONFIGURATION_DESIRED_CAPACITY =>
        val r = RecommendationOptionsConfigurationDesiredCapacity
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.RECOMMENDATION_OPTIONS_CONFIGURATION_MIN_SIZE =>
        val r = RecommendationOptionsConfigurationMinSize
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.RECOMMENDATION_OPTIONS_CONFIGURATION_MAX_SIZE =>
        val r = RecommendationOptionsConfigurationMaxSize
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.RECOMMENDATION_OPTIONS_PROJECTED_UTILIZATION_METRICS_CPU_MAXIMUM =>
        val r = RecommendationOptionsProjectedUtilizationMetricsCpuMaximum
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.RECOMMENDATION_OPTIONS_PROJECTED_UTILIZATION_METRICS_MEMORY_MAXIMUM =>
        val r = RecommendationOptionsProjectedUtilizationMetricsMemoryMaximum
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.RECOMMENDATION_OPTIONS_PERFORMANCE_RISK =>
        val r = RecommendationOptionsPerformanceRisk
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.RECOMMENDATION_OPTIONS_ON_DEMAND_PRICE =>
        val r = RecommendationOptionsOnDemandPrice
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.RECOMMENDATION_OPTIONS_STANDARD_ONE_YEAR_NO_UPFRONT_RESERVED_PRICE =>
        val r = RecommendationOptionsStandardOneYearNoUpfrontReservedPrice
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.RECOMMENDATION_OPTIONS_STANDARD_THREE_YEAR_NO_UPFRONT_RESERVED_PRICE =>
        val r = RecommendationOptionsStandardThreeYearNoUpfrontReservedPrice
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.RECOMMENDATION_OPTIONS_VCPUS =>
        val r = RecommendationOptionsVcpus
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.RECOMMENDATION_OPTIONS_MEMORY =>
        val r = RecommendationOptionsMemory
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.RECOMMENDATION_OPTIONS_STORAGE =>
        val r = RecommendationOptionsStorage
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.RECOMMENDATION_OPTIONS_NETWORK =>
        val r = RecommendationOptionsNetwork
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.LAST_REFRESH_TIMESTAMP =>
        val r = LastRefreshTimestamp
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.CURRENT_PERFORMANCE_RISK =>
        val r = CurrentPerformanceRisk
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.RECOMMENDATION_OPTIONS_SAVINGS_OPPORTUNITY_PERCENTAGE =>
        val r = RecommendationOptionsSavingsOpportunityPercentage
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_CURRENCY =>
        val r = RecommendationOptionsEstimatedMonthlySavingsCurrency
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_VALUE =>
        val r = RecommendationOptionsEstimatedMonthlySavingsValue
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.EFFECTIVE_RECOMMENDATION_PREFERENCES_CPU_VENDOR_ARCHITECTURES =>
        val r = EffectiveRecommendationPreferencesCpuVendorArchitectures
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.EFFECTIVE_RECOMMENDATION_PREFERENCES_ENHANCED_INFRASTRUCTURE_METRICS =>
        val r = EffectiveRecommendationPreferencesEnhancedInfrastructureMetrics
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.EFFECTIVE_RECOMMENDATION_PREFERENCES_INFERRED_WORKLOAD_TYPES =>
        val r = EffectiveRecommendationPreferencesInferredWorkloadTypes
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.INFERRED_WORKLOAD_TYPES =>
        val r = InferredWorkloadTypes
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.RECOMMENDATION_OPTIONS_MIGRATION_EFFORT =>
        val r = RecommendationOptionsMigrationEffort
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.UNKNOWN_TO_SDK_VERSION
  }
  case object AccountId
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.ACCOUNT_ID
  }
  case object AutoScalingGroupArn
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.AUTO_SCALING_GROUP_ARN
  }
  case object AutoScalingGroupName
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.AUTO_SCALING_GROUP_NAME
  }
  case object Finding
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.FINDING
  }
  case object UtilizationMetricsCpuMaximum
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.UTILIZATION_METRICS_CPU_MAXIMUM
  }
  case object UtilizationMetricsMemoryMaximum
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.UTILIZATION_METRICS_MEMORY_MAXIMUM
  }
  case object UtilizationMetricsEbsReadOpsPerSecondMaximum
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.UTILIZATION_METRICS_EBS_READ_OPS_PER_SECOND_MAXIMUM
  }
  case object UtilizationMetricsEbsWriteOpsPerSecondMaximum
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.UTILIZATION_METRICS_EBS_WRITE_OPS_PER_SECOND_MAXIMUM
  }
  case object UtilizationMetricsEbsReadBytesPerSecondMaximum
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.UTILIZATION_METRICS_EBS_READ_BYTES_PER_SECOND_MAXIMUM
  }
  case object UtilizationMetricsEbsWriteBytesPerSecondMaximum
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.UTILIZATION_METRICS_EBS_WRITE_BYTES_PER_SECOND_MAXIMUM
  }
  case object UtilizationMetricsDiskReadOpsPerSecondMaximum
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.UTILIZATION_METRICS_DISK_READ_OPS_PER_SECOND_MAXIMUM
  }
  case object UtilizationMetricsDiskWriteOpsPerSecondMaximum
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.UTILIZATION_METRICS_DISK_WRITE_OPS_PER_SECOND_MAXIMUM
  }
  case object UtilizationMetricsDiskReadBytesPerSecondMaximum
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.UTILIZATION_METRICS_DISK_READ_BYTES_PER_SECOND_MAXIMUM
  }
  case object UtilizationMetricsDiskWriteBytesPerSecondMaximum
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.UTILIZATION_METRICS_DISK_WRITE_BYTES_PER_SECOND_MAXIMUM
  }
  case object UtilizationMetricsNetworkInBytesPerSecondMaximum
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.UTILIZATION_METRICS_NETWORK_IN_BYTES_PER_SECOND_MAXIMUM
  }
  case object UtilizationMetricsNetworkOutBytesPerSecondMaximum
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.UTILIZATION_METRICS_NETWORK_OUT_BYTES_PER_SECOND_MAXIMUM
  }
  case object UtilizationMetricsNetworkPacketsInPerSecondMaximum
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.UTILIZATION_METRICS_NETWORK_PACKETS_IN_PER_SECOND_MAXIMUM
  }
  case object UtilizationMetricsNetworkPacketsOutPerSecondMaximum
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.UTILIZATION_METRICS_NETWORK_PACKETS_OUT_PER_SECOND_MAXIMUM
  }
  case object LookbackPeriodInDays
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.LOOKBACK_PERIOD_IN_DAYS
  }
  case object CurrentConfigurationInstanceType
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.CURRENT_CONFIGURATION_INSTANCE_TYPE
  }
  case object CurrentConfigurationDesiredCapacity
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.CURRENT_CONFIGURATION_DESIRED_CAPACITY
  }
  case object CurrentConfigurationMinSize
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.CURRENT_CONFIGURATION_MIN_SIZE
  }
  case object CurrentConfigurationMaxSize
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.CURRENT_CONFIGURATION_MAX_SIZE
  }
  case object CurrentOnDemandPrice
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.CURRENT_ON_DEMAND_PRICE
  }
  case object CurrentStandardOneYearNoUpfrontReservedPrice
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.CURRENT_STANDARD_ONE_YEAR_NO_UPFRONT_RESERVED_PRICE
  }
  case object CurrentStandardThreeYearNoUpfrontReservedPrice
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.CURRENT_STANDARD_THREE_YEAR_NO_UPFRONT_RESERVED_PRICE
  }
  case object CurrentVCpus
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.CURRENT_V_CPUS
  }
  case object CurrentMemory
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.CURRENT_MEMORY
  }
  case object CurrentStorage
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.CURRENT_STORAGE
  }
  case object CurrentNetwork
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.CURRENT_NETWORK
  }
  case object RecommendationOptionsConfigurationInstanceType
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.RECOMMENDATION_OPTIONS_CONFIGURATION_INSTANCE_TYPE
  }
  case object RecommendationOptionsConfigurationDesiredCapacity
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.RECOMMENDATION_OPTIONS_CONFIGURATION_DESIRED_CAPACITY
  }
  case object RecommendationOptionsConfigurationMinSize
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.RECOMMENDATION_OPTIONS_CONFIGURATION_MIN_SIZE
  }
  case object RecommendationOptionsConfigurationMaxSize
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.RECOMMENDATION_OPTIONS_CONFIGURATION_MAX_SIZE
  }
  case object RecommendationOptionsProjectedUtilizationMetricsCpuMaximum
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.RECOMMENDATION_OPTIONS_PROJECTED_UTILIZATION_METRICS_CPU_MAXIMUM
  }
  case object RecommendationOptionsProjectedUtilizationMetricsMemoryMaximum
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.RECOMMENDATION_OPTIONS_PROJECTED_UTILIZATION_METRICS_MEMORY_MAXIMUM
  }
  case object RecommendationOptionsPerformanceRisk
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.RECOMMENDATION_OPTIONS_PERFORMANCE_RISK
  }
  case object RecommendationOptionsOnDemandPrice
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.RECOMMENDATION_OPTIONS_ON_DEMAND_PRICE
  }
  case object RecommendationOptionsStandardOneYearNoUpfrontReservedPrice
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.RECOMMENDATION_OPTIONS_STANDARD_ONE_YEAR_NO_UPFRONT_RESERVED_PRICE
  }
  case object RecommendationOptionsStandardThreeYearNoUpfrontReservedPrice
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.RECOMMENDATION_OPTIONS_STANDARD_THREE_YEAR_NO_UPFRONT_RESERVED_PRICE
  }
  case object RecommendationOptionsVcpus
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.RECOMMENDATION_OPTIONS_VCPUS
  }
  case object RecommendationOptionsMemory
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.RECOMMENDATION_OPTIONS_MEMORY
  }
  case object RecommendationOptionsStorage
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.RECOMMENDATION_OPTIONS_STORAGE
  }
  case object RecommendationOptionsNetwork
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.RECOMMENDATION_OPTIONS_NETWORK
  }
  case object LastRefreshTimestamp
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.LAST_REFRESH_TIMESTAMP
  }
  case object CurrentPerformanceRisk
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.CURRENT_PERFORMANCE_RISK
  }
  case object RecommendationOptionsSavingsOpportunityPercentage
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.RECOMMENDATION_OPTIONS_SAVINGS_OPPORTUNITY_PERCENTAGE
  }
  case object RecommendationOptionsEstimatedMonthlySavingsCurrency
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_CURRENCY
  }
  case object RecommendationOptionsEstimatedMonthlySavingsValue
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_VALUE
  }
  case object EffectiveRecommendationPreferencesCpuVendorArchitectures
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.EFFECTIVE_RECOMMENDATION_PREFERENCES_CPU_VENDOR_ARCHITECTURES
  }
  case object EffectiveRecommendationPreferencesEnhancedInfrastructureMetrics
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.EFFECTIVE_RECOMMENDATION_PREFERENCES_ENHANCED_INFRASTRUCTURE_METRICS
  }
  case object EffectiveRecommendationPreferencesInferredWorkloadTypes
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.EFFECTIVE_RECOMMENDATION_PREFERENCES_INFERRED_WORKLOAD_TYPES
  }
  case object InferredWorkloadTypes
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.INFERRED_WORKLOAD_TYPES
  }
  case object RecommendationOptionsMigrationEffort
      extends zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableAutoScalingGroupField.RECOMMENDATION_OPTIONS_MIGRATION_EFFORT
  }
}
