package zio.aws.computeoptimizer.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.computeoptimizer.model.primitives.{Rank, RecommendedInstanceType}
import scala.jdk.CollectionConverters._
final case class RecommendedOptionProjectedMetric(
    recommendedInstanceType: Option[RecommendedInstanceType] = None,
    rank: Option[Rank] = None,
    projectedMetrics: Option[
      Iterable[zio.aws.computeoptimizer.model.ProjectedMetric]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.RecommendedOptionProjectedMetric = {
    import RecommendedOptionProjectedMetric.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.RecommendedOptionProjectedMetric
      .builder()
      .optionallyWith(
        recommendedInstanceType.map(value =>
          RecommendedInstanceType.unwrap(value): java.lang.String
        )
      )(_.recommendedInstanceType)
      .optionallyWith(rank.map(value => Rank.unwrap(value): Integer))(_.rank)
      .optionallyWith(
        projectedMetrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.projectedMetrics)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.RecommendedOptionProjectedMetric.ReadOnly =
    zio.aws.computeoptimizer.model.RecommendedOptionProjectedMetric
      .wrap(buildAwsValue())
}
object RecommendedOptionProjectedMetric {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.RecommendedOptionProjectedMetric
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.RecommendedOptionProjectedMetric =
      zio.aws.computeoptimizer.model.RecommendedOptionProjectedMetric(
        recommendedInstanceType.map(value => value),
        rank.map(value => value),
        projectedMetrics.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def recommendedInstanceType: Option[RecommendedInstanceType]
    def rank: Option[Rank]
    def projectedMetrics
        : Option[List[zio.aws.computeoptimizer.model.ProjectedMetric.ReadOnly]]
    def getRecommendedInstanceType
        : ZIO[Any, AwsError, RecommendedInstanceType] = AwsError
      .unwrapOptionField("recommendedInstanceType", recommendedInstanceType)
    def getRank: ZIO[Any, AwsError, Rank] =
      AwsError.unwrapOptionField("rank", rank)
    def getProjectedMetrics: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.ProjectedMetric.ReadOnly
    ]] = AwsError.unwrapOptionField("projectedMetrics", projectedMetrics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.RecommendedOptionProjectedMetric
  ) extends zio.aws.computeoptimizer.model.RecommendedOptionProjectedMetric.ReadOnly {
    override val recommendedInstanceType: Option[RecommendedInstanceType] =
      scala
        .Option(impl.recommendedInstanceType())
        .map(value =>
          zio.aws.computeoptimizer.model.primitives
            .RecommendedInstanceType(value)
        )
    override val rank: Option[Rank] = scala
      .Option(impl.rank())
      .map(value => zio.aws.computeoptimizer.model.primitives.Rank(value))
    override val projectedMetrics: Option[
      List[zio.aws.computeoptimizer.model.ProjectedMetric.ReadOnly]
    ] = scala
      .Option(impl.projectedMetrics())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.ProjectedMetric.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.RecommendedOptionProjectedMetric
  ): zio.aws.computeoptimizer.model.RecommendedOptionProjectedMetric.ReadOnly =
    new Wrapper(impl)
}
