package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters._
sealed trait ResourceType {
  def unwrap
      : software.amazon.awssdk.services.computeoptimizer.model.ResourceType
}
object ResourceType {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.ResourceType
  ): zio.aws.computeoptimizer.model.ResourceType = value match {
    case software.amazon.awssdk.services.computeoptimizer.model.ResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ResourceType.EC2_INSTANCE =>
      val r = Ec2Instance
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ResourceType.AUTO_SCALING_GROUP =>
      val r = AutoScalingGroup
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ResourceType.EBS_VOLUME =>
      val r = EbsVolume
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ResourceType.LAMBDA_FUNCTION =>
      val r = LambdaFunction
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ResourceType.NOT_APPLICABLE =>
      val r = NotApplicable
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ResourceType =
      software.amazon.awssdk.services.computeoptimizer.model.ResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object Ec2Instance extends zio.aws.computeoptimizer.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ResourceType =
      software.amazon.awssdk.services.computeoptimizer.model.ResourceType.EC2_INSTANCE
  }
  case object AutoScalingGroup
      extends zio.aws.computeoptimizer.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ResourceType =
      software.amazon.awssdk.services.computeoptimizer.model.ResourceType.AUTO_SCALING_GROUP
  }
  case object EbsVolume extends zio.aws.computeoptimizer.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ResourceType =
      software.amazon.awssdk.services.computeoptimizer.model.ResourceType.EBS_VOLUME
  }
  case object LambdaFunction
      extends zio.aws.computeoptimizer.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ResourceType =
      software.amazon.awssdk.services.computeoptimizer.model.ResourceType.LAMBDA_FUNCTION
  }
  case object NotApplicable
      extends zio.aws.computeoptimizer.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ResourceType =
      software.amazon.awssdk.services.computeoptimizer.model.ResourceType.NOT_APPLICABLE
  }
}
