package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EffectiveRecommendationPreferences(
    cpuVendorArchitectures: Option[
      Iterable[zio.aws.computeoptimizer.model.CpuVendorArchitecture]
    ] = None,
    enhancedInfrastructureMetrics: Option[
      zio.aws.computeoptimizer.model.EnhancedInfrastructureMetrics
    ] = None,
    inferredWorkloadTypes: Option[
      zio.aws.computeoptimizer.model.InferredWorkloadTypesPreference
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.EffectiveRecommendationPreferences = {
    import EffectiveRecommendationPreferences.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.EffectiveRecommendationPreferences
      .builder()
      .optionallyWith(
        cpuVendorArchitectures.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.cpuVendorArchitecturesWithStrings)
      .optionallyWith(enhancedInfrastructureMetrics.map(value => value.unwrap))(
        _.enhancedInfrastructureMetrics
      )
      .optionallyWith(inferredWorkloadTypes.map(value => value.unwrap))(
        _.inferredWorkloadTypes
      )
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.EffectiveRecommendationPreferences.ReadOnly =
    zio.aws.computeoptimizer.model.EffectiveRecommendationPreferences
      .wrap(buildAwsValue())
}
object EffectiveRecommendationPreferences {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.EffectiveRecommendationPreferences
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.EffectiveRecommendationPreferences =
      zio.aws.computeoptimizer.model.EffectiveRecommendationPreferences(
        cpuVendorArchitectures.map(value => value),
        enhancedInfrastructureMetrics.map(value => value),
        inferredWorkloadTypes.map(value => value)
      )
    def cpuVendorArchitectures
        : Option[List[zio.aws.computeoptimizer.model.CpuVendorArchitecture]]
    def enhancedInfrastructureMetrics
        : Option[zio.aws.computeoptimizer.model.EnhancedInfrastructureMetrics]
    def inferredWorkloadTypes
        : Option[zio.aws.computeoptimizer.model.InferredWorkloadTypesPreference]
    def getCpuVendorArchitectures: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.CpuVendorArchitecture
    ]] = AwsError.unwrapOptionField(
      "cpuVendorArchitectures",
      cpuVendorArchitectures
    )
    def getEnhancedInfrastructureMetrics: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.EnhancedInfrastructureMetrics
    ] = AwsError.unwrapOptionField(
      "enhancedInfrastructureMetrics",
      enhancedInfrastructureMetrics
    )
    def getInferredWorkloadTypes: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.InferredWorkloadTypesPreference
    ] =
      AwsError.unwrapOptionField("inferredWorkloadTypes", inferredWorkloadTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.EffectiveRecommendationPreferences
  ) extends zio.aws.computeoptimizer.model.EffectiveRecommendationPreferences.ReadOnly {
    override val cpuVendorArchitectures
        : Option[List[zio.aws.computeoptimizer.model.CpuVendorArchitecture]] =
      scala
        .Option(impl.cpuVendorArchitectures())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.computeoptimizer.model.CpuVendorArchitecture.wrap(item)
          }.toList
        )
    override val enhancedInfrastructureMetrics
        : Option[zio.aws.computeoptimizer.model.EnhancedInfrastructureMetrics] =
      scala
        .Option(impl.enhancedInfrastructureMetrics())
        .map(value =>
          zio.aws.computeoptimizer.model.EnhancedInfrastructureMetrics
            .wrap(value)
        )
    override val inferredWorkloadTypes: Option[
      zio.aws.computeoptimizer.model.InferredWorkloadTypesPreference
    ] = scala
      .Option(impl.inferredWorkloadTypes())
      .map(value =>
        zio.aws.computeoptimizer.model.InferredWorkloadTypesPreference
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.EffectiveRecommendationPreferences
  ): zio.aws.computeoptimizer.model.EffectiveRecommendationPreferences.ReadOnly =
    new Wrapper(impl)
}
