package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.computeoptimizer.model.primitives.{
  LastRefreshTimestamp,
  LookBackPeriodInDays,
  AccountId,
  VolumeArn
}
import scala.jdk.CollectionConverters._
final case class VolumeRecommendation(
    volumeArn: Option[VolumeArn] = None,
    accountId: Option[AccountId] = None,
    currentConfiguration: Option[
      zio.aws.computeoptimizer.model.VolumeConfiguration
    ] = None,
    finding: Option[zio.aws.computeoptimizer.model.EBSFinding] = None,
    utilizationMetrics: Option[
      Iterable[zio.aws.computeoptimizer.model.EBSUtilizationMetric]
    ] = None,
    lookBackPeriodInDays: Option[LookBackPeriodInDays] = None,
    volumeRecommendationOptions: Option[
      Iterable[zio.aws.computeoptimizer.model.VolumeRecommendationOption]
    ] = None,
    lastRefreshTimestamp: Option[LastRefreshTimestamp] = None,
    currentPerformanceRisk: Option[
      zio.aws.computeoptimizer.model.CurrentPerformanceRisk
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.VolumeRecommendation = {
    import VolumeRecommendation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.VolumeRecommendation
      .builder()
      .optionallyWith(
        volumeArn.map(value => VolumeArn.unwrap(value): java.lang.String)
      )(_.volumeArn)
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(currentConfiguration.map(value => value.buildAwsValue()))(
        _.currentConfiguration
      )
      .optionallyWith(finding.map(value => value.unwrap))(_.finding)
      .optionallyWith(
        utilizationMetrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.utilizationMetrics)
      .optionallyWith(
        lookBackPeriodInDays.map(value =>
          LookBackPeriodInDays.unwrap(value): java.lang.Double
        )
      )(_.lookBackPeriodInDays)
      .optionallyWith(
        volumeRecommendationOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.volumeRecommendationOptions)
      .optionallyWith(
        lastRefreshTimestamp.map(value =>
          LastRefreshTimestamp.unwrap(value): Instant
        )
      )(_.lastRefreshTimestamp)
      .optionallyWith(currentPerformanceRisk.map(value => value.unwrap))(
        _.currentPerformanceRisk
      )
      .build()
  }
  def asReadOnly: zio.aws.computeoptimizer.model.VolumeRecommendation.ReadOnly =
    zio.aws.computeoptimizer.model.VolumeRecommendation.wrap(buildAwsValue())
}
object VolumeRecommendation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.VolumeRecommendation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.computeoptimizer.model.VolumeRecommendation =
      zio.aws.computeoptimizer.model.VolumeRecommendation(
        volumeArn.map(value => value),
        accountId.map(value => value),
        currentConfiguration.map(value => value.asEditable),
        finding.map(value => value),
        utilizationMetrics.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lookBackPeriodInDays.map(value => value),
        volumeRecommendationOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lastRefreshTimestamp.map(value => value),
        currentPerformanceRisk.map(value => value)
      )
    def volumeArn: Option[VolumeArn]
    def accountId: Option[AccountId]
    def currentConfiguration
        : Option[zio.aws.computeoptimizer.model.VolumeConfiguration.ReadOnly]
    def finding: Option[zio.aws.computeoptimizer.model.EBSFinding]
    def utilizationMetrics: Option[
      List[zio.aws.computeoptimizer.model.EBSUtilizationMetric.ReadOnly]
    ]
    def lookBackPeriodInDays: Option[LookBackPeriodInDays]
    def volumeRecommendationOptions: Option[
      List[zio.aws.computeoptimizer.model.VolumeRecommendationOption.ReadOnly]
    ]
    def lastRefreshTimestamp: Option[LastRefreshTimestamp]
    def currentPerformanceRisk
        : Option[zio.aws.computeoptimizer.model.CurrentPerformanceRisk]
    def getVolumeArn: ZIO[Any, AwsError, VolumeArn] =
      AwsError.unwrapOptionField("volumeArn", volumeArn)
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getCurrentConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.VolumeConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("currentConfiguration", currentConfiguration)
    def getFinding
        : ZIO[Any, AwsError, zio.aws.computeoptimizer.model.EBSFinding] =
      AwsError.unwrapOptionField("finding", finding)
    def getUtilizationMetrics: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.EBSUtilizationMetric.ReadOnly
    ]] = AwsError.unwrapOptionField("utilizationMetrics", utilizationMetrics)
    def getLookBackPeriodInDays: ZIO[Any, AwsError, LookBackPeriodInDays] =
      AwsError.unwrapOptionField("lookBackPeriodInDays", lookBackPeriodInDays)
    def getVolumeRecommendationOptions: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.VolumeRecommendationOption.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "volumeRecommendationOptions",
      volumeRecommendationOptions
    )
    def getLastRefreshTimestamp: ZIO[Any, AwsError, LastRefreshTimestamp] =
      AwsError.unwrapOptionField("lastRefreshTimestamp", lastRefreshTimestamp)
    def getCurrentPerformanceRisk: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.CurrentPerformanceRisk
    ] = AwsError.unwrapOptionField(
      "currentPerformanceRisk",
      currentPerformanceRisk
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.VolumeRecommendation
  ) extends zio.aws.computeoptimizer.model.VolumeRecommendation.ReadOnly {
    override val volumeArn: Option[VolumeArn] = scala
      .Option(impl.volumeArn())
      .map(value => zio.aws.computeoptimizer.model.primitives.VolumeArn(value))
    override val accountId: Option[AccountId] = scala
      .Option(impl.accountId())
      .map(value => zio.aws.computeoptimizer.model.primitives.AccountId(value))
    override val currentConfiguration
        : Option[zio.aws.computeoptimizer.model.VolumeConfiguration.ReadOnly] =
      scala
        .Option(impl.currentConfiguration())
        .map(value =>
          zio.aws.computeoptimizer.model.VolumeConfiguration.wrap(value)
        )
    override val finding: Option[zio.aws.computeoptimizer.model.EBSFinding] =
      scala
        .Option(impl.finding())
        .map(value => zio.aws.computeoptimizer.model.EBSFinding.wrap(value))
    override val utilizationMetrics: Option[
      List[zio.aws.computeoptimizer.model.EBSUtilizationMetric.ReadOnly]
    ] = scala
      .Option(impl.utilizationMetrics())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.EBSUtilizationMetric.wrap(item)
        }.toList
      )
    override val lookBackPeriodInDays: Option[LookBackPeriodInDays] = scala
      .Option(impl.lookBackPeriodInDays())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.LookBackPeriodInDays(value)
      )
    override val volumeRecommendationOptions: Option[
      List[zio.aws.computeoptimizer.model.VolumeRecommendationOption.ReadOnly]
    ] = scala
      .Option(impl.volumeRecommendationOptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.VolumeRecommendationOption.wrap(item)
        }.toList
      )
    override val lastRefreshTimestamp: Option[LastRefreshTimestamp] = scala
      .Option(impl.lastRefreshTimestamp())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.LastRefreshTimestamp(value)
      )
    override val currentPerformanceRisk
        : Option[zio.aws.computeoptimizer.model.CurrentPerformanceRisk] = scala
      .Option(impl.currentPerformanceRisk())
      .map(value =>
        zio.aws.computeoptimizer.model.CurrentPerformanceRisk.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.VolumeRecommendation
  ): zio.aws.computeoptimizer.model.VolumeRecommendation.ReadOnly = new Wrapper(
    impl
  )
}
