package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.computeoptimizer.model.primitives.SummaryValue
import scala.jdk.CollectionConverters._
final case class ReasonCodeSummary(
    name: Option[zio.aws.computeoptimizer.model.FindingReasonCode] = None,
    value: Option[SummaryValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.ReasonCodeSummary = {
    import ReasonCodeSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.ReasonCodeSummary
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(
        value.map(value => SummaryValue.unwrap(value): java.lang.Double)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.computeoptimizer.model.ReasonCodeSummary.ReadOnly =
    zio.aws.computeoptimizer.model.ReasonCodeSummary.wrap(buildAwsValue())
}
object ReasonCodeSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.ReasonCodeSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.computeoptimizer.model.ReasonCodeSummary =
      zio.aws.computeoptimizer.model
        .ReasonCodeSummary(name.map(value => value), value.map(value => value))
    def name: Option[zio.aws.computeoptimizer.model.FindingReasonCode]
    def value: Option[SummaryValue]
    def getName
        : ZIO[Any, AwsError, zio.aws.computeoptimizer.model.FindingReasonCode] =
      AwsError.unwrapOptionField("name", name)
    def getValue: ZIO[Any, AwsError, SummaryValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.ReasonCodeSummary
  ) extends zio.aws.computeoptimizer.model.ReasonCodeSummary.ReadOnly {
    override val name
        : Option[zio.aws.computeoptimizer.model.FindingReasonCode] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.computeoptimizer.model.FindingReasonCode.wrap(value)
      )
    override val value: Option[SummaryValue] = scala
      .Option(impl.value())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.SummaryValue(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.ReasonCodeSummary
  ): zio.aws.computeoptimizer.model.ReasonCodeSummary.ReadOnly = new Wrapper(
    impl
  )
}
