package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.computeoptimizer.model.primitives.MetricValue
import scala.jdk.CollectionConverters._
final case class EBSUtilizationMetric(
    name: Option[zio.aws.computeoptimizer.model.EBSMetricName] = None,
    statistic: Option[zio.aws.computeoptimizer.model.MetricStatistic] = None,
    value: Option[MetricValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.EBSUtilizationMetric = {
    import EBSUtilizationMetric.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.EBSUtilizationMetric
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(statistic.map(value => value.unwrap))(_.statistic)
      .optionallyWith(
        value.map(value => MetricValue.unwrap(value): java.lang.Double)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.computeoptimizer.model.EBSUtilizationMetric.ReadOnly =
    zio.aws.computeoptimizer.model.EBSUtilizationMetric.wrap(buildAwsValue())
}
object EBSUtilizationMetric {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.EBSUtilizationMetric
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.computeoptimizer.model.EBSUtilizationMetric =
      zio.aws.computeoptimizer.model.EBSUtilizationMetric(
        name.map(value => value),
        statistic.map(value => value),
        value.map(value => value)
      )
    def name: Option[zio.aws.computeoptimizer.model.EBSMetricName]
    def statistic: Option[zio.aws.computeoptimizer.model.MetricStatistic]
    def value: Option[MetricValue]
    def getName
        : ZIO[Any, AwsError, zio.aws.computeoptimizer.model.EBSMetricName] =
      AwsError.unwrapOptionField("name", name)
    def getStatistic
        : ZIO[Any, AwsError, zio.aws.computeoptimizer.model.MetricStatistic] =
      AwsError.unwrapOptionField("statistic", statistic)
    def getValue: ZIO[Any, AwsError, MetricValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.EBSUtilizationMetric
  ) extends zio.aws.computeoptimizer.model.EBSUtilizationMetric.ReadOnly {
    override val name: Option[zio.aws.computeoptimizer.model.EBSMetricName] =
      scala
        .Option(impl.name())
        .map(value => zio.aws.computeoptimizer.model.EBSMetricName.wrap(value))
    override val statistic
        : Option[zio.aws.computeoptimizer.model.MetricStatistic] = scala
      .Option(impl.statistic())
      .map(value => zio.aws.computeoptimizer.model.MetricStatistic.wrap(value))
    override val value: Option[MetricValue] = scala
      .Option(impl.value())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.MetricValue(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.EBSUtilizationMetric
  ): zio.aws.computeoptimizer.model.EBSUtilizationMetric.ReadOnly = new Wrapper(
    impl
  )
}
