package zio.aws.computeoptimizer.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.computeoptimizer.model.primitives.{MaxResults, NextToken, JobId}
import scala.jdk.CollectionConverters._
final case class DescribeRecommendationExportJobsRequest(
    jobIds: Option[Iterable[JobId]] = None,
    filters: Option[Iterable[zio.aws.computeoptimizer.model.JobFilter]] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.DescribeRecommendationExportJobsRequest = {
    import DescribeRecommendationExportJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.DescribeRecommendationExportJobsRequest
      .builder()
      .optionallyWith(
        jobIds.map(value =>
          value.map { item =>
            JobId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.jobIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.DescribeRecommendationExportJobsRequest.ReadOnly =
    zio.aws.computeoptimizer.model.DescribeRecommendationExportJobsRequest
      .wrap(buildAwsValue())
}
object DescribeRecommendationExportJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.DescribeRecommendationExportJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.DescribeRecommendationExportJobsRequest =
      zio.aws.computeoptimizer.model.DescribeRecommendationExportJobsRequest(
        jobIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def jobIds: Option[List[JobId]]
    def filters: Option[List[zio.aws.computeoptimizer.model.JobFilter.ReadOnly]]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getJobIds: ZIO[Any, AwsError, List[JobId]] =
      AwsError.unwrapOptionField("jobIds", jobIds)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.JobFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.DescribeRecommendationExportJobsRequest
  ) extends zio.aws.computeoptimizer.model.DescribeRecommendationExportJobsRequest.ReadOnly {
    override val jobIds: Option[List[JobId]] = scala
      .Option(impl.jobIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.primitives.JobId(item)
        }.toList
      )
    override val filters
        : Option[List[zio.aws.computeoptimizer.model.JobFilter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.computeoptimizer.model.JobFilter.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.computeoptimizer.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.computeoptimizer.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.DescribeRecommendationExportJobsRequest
  ): zio.aws.computeoptimizer.model.DescribeRecommendationExportJobsRequest.ReadOnly =
    new Wrapper(impl)
}
