package zio.aws.computeoptimizer.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.computeoptimizer.model.primitives.{Rank, PerformanceRisk}
import scala.jdk.CollectionConverters._
final case class AutoScalingGroupRecommendationOption(
    configuration: Option[
      zio.aws.computeoptimizer.model.AutoScalingGroupConfiguration
    ] = None,
    projectedUtilizationMetrics: Option[
      Iterable[zio.aws.computeoptimizer.model.UtilizationMetric]
    ] = None,
    performanceRisk: Option[PerformanceRisk] = None,
    rank: Option[Rank] = None,
    savingsOpportunity: Option[
      zio.aws.computeoptimizer.model.SavingsOpportunity
    ] = None,
    migrationEffort: Option[zio.aws.computeoptimizer.model.MigrationEffort] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.AutoScalingGroupRecommendationOption = {
    import AutoScalingGroupRecommendationOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.AutoScalingGroupRecommendationOption
      .builder()
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .optionallyWith(
        projectedUtilizationMetrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.projectedUtilizationMetrics)
      .optionallyWith(
        performanceRisk.map(value =>
          PerformanceRisk.unwrap(value): java.lang.Double
        )
      )(_.performanceRisk)
      .optionallyWith(rank.map(value => Rank.unwrap(value): Integer))(_.rank)
      .optionallyWith(savingsOpportunity.map(value => value.buildAwsValue()))(
        _.savingsOpportunity
      )
      .optionallyWith(migrationEffort.map(value => value.unwrap))(
        _.migrationEffort
      )
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.AutoScalingGroupRecommendationOption.ReadOnly =
    zio.aws.computeoptimizer.model.AutoScalingGroupRecommendationOption
      .wrap(buildAwsValue())
}
object AutoScalingGroupRecommendationOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.AutoScalingGroupRecommendationOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.AutoScalingGroupRecommendationOption =
      zio.aws.computeoptimizer.model.AutoScalingGroupRecommendationOption(
        configuration.map(value => value.asEditable),
        projectedUtilizationMetrics.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        performanceRisk.map(value => value),
        rank.map(value => value),
        savingsOpportunity.map(value => value.asEditable),
        migrationEffort.map(value => value)
      )
    def configuration: Option[
      zio.aws.computeoptimizer.model.AutoScalingGroupConfiguration.ReadOnly
    ]
    def projectedUtilizationMetrics: Option[
      List[zio.aws.computeoptimizer.model.UtilizationMetric.ReadOnly]
    ]
    def performanceRisk: Option[PerformanceRisk]
    def rank: Option[Rank]
    def savingsOpportunity
        : Option[zio.aws.computeoptimizer.model.SavingsOpportunity.ReadOnly]
    def migrationEffort: Option[zio.aws.computeoptimizer.model.MigrationEffort]
    def getConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.AutoScalingGroupConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("configuration", configuration)
    def getProjectedUtilizationMetrics: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.UtilizationMetric.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "projectedUtilizationMetrics",
      projectedUtilizationMetrics
    )
    def getPerformanceRisk: ZIO[Any, AwsError, PerformanceRisk] =
      AwsError.unwrapOptionField("performanceRisk", performanceRisk)
    def getRank: ZIO[Any, AwsError, Rank] =
      AwsError.unwrapOptionField("rank", rank)
    def getSavingsOpportunity: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.SavingsOpportunity.ReadOnly
    ] = AwsError.unwrapOptionField("savingsOpportunity", savingsOpportunity)
    def getMigrationEffort
        : ZIO[Any, AwsError, zio.aws.computeoptimizer.model.MigrationEffort] =
      AwsError.unwrapOptionField("migrationEffort", migrationEffort)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.AutoScalingGroupRecommendationOption
  ) extends zio.aws.computeoptimizer.model.AutoScalingGroupRecommendationOption.ReadOnly {
    override val configuration: Option[
      zio.aws.computeoptimizer.model.AutoScalingGroupConfiguration.ReadOnly
    ] = scala
      .Option(impl.configuration())
      .map(value =>
        zio.aws.computeoptimizer.model.AutoScalingGroupConfiguration.wrap(value)
      )
    override val projectedUtilizationMetrics: Option[
      List[zio.aws.computeoptimizer.model.UtilizationMetric.ReadOnly]
    ] = scala
      .Option(impl.projectedUtilizationMetrics())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.UtilizationMetric.wrap(item)
        }.toList
      )
    override val performanceRisk: Option[PerformanceRisk] = scala
      .Option(impl.performanceRisk())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.PerformanceRisk(value)
      )
    override val rank: Option[Rank] = scala
      .Option(impl.rank())
      .map(value => zio.aws.computeoptimizer.model.primitives.Rank(value))
    override val savingsOpportunity
        : Option[zio.aws.computeoptimizer.model.SavingsOpportunity.ReadOnly] =
      scala
        .Option(impl.savingsOpportunity())
        .map(value =>
          zio.aws.computeoptimizer.model.SavingsOpportunity.wrap(value)
        )
    override val migrationEffort
        : Option[zio.aws.computeoptimizer.model.MigrationEffort] = scala
      .Option(impl.migrationEffort())
      .map(value => zio.aws.computeoptimizer.model.MigrationEffort.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.AutoScalingGroupRecommendationOption
  ): zio.aws.computeoptimizer.model.AutoScalingGroupRecommendationOption.ReadOnly =
    new Wrapper(impl)
}
