package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.computeoptimizer.model.primitives.SummaryValue
import scala.jdk.CollectionConverters._
final case class Summary(
    name: Option[zio.aws.computeoptimizer.model.Finding] = None,
    value: Option[SummaryValue] = None,
    reasonCodeSummaries: Option[
      Iterable[zio.aws.computeoptimizer.model.ReasonCodeSummary]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.Summary = {
    import Summary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.Summary
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(
        value.map(value => SummaryValue.unwrap(value): java.lang.Double)
      )(_.value)
      .optionallyWith(
        reasonCodeSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reasonCodeSummaries)
      .build()
  }
  def asReadOnly: zio.aws.computeoptimizer.model.Summary.ReadOnly =
    zio.aws.computeoptimizer.model.Summary.wrap(buildAwsValue())
}
object Summary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.Summary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.computeoptimizer.model.Summary =
      zio.aws.computeoptimizer.model.Summary(
        name.map(value => value),
        value.map(value => value),
        reasonCodeSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: Option[zio.aws.computeoptimizer.model.Finding]
    def value: Option[SummaryValue]
    def reasonCodeSummaries: Option[
      List[zio.aws.computeoptimizer.model.ReasonCodeSummary.ReadOnly]
    ]
    def getName: ZIO[Any, AwsError, zio.aws.computeoptimizer.model.Finding] =
      AwsError.unwrapOptionField("name", name)
    def getValue: ZIO[Any, AwsError, SummaryValue] =
      AwsError.unwrapOptionField("value", value)
    def getReasonCodeSummaries: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.ReasonCodeSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("reasonCodeSummaries", reasonCodeSummaries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.Summary
  ) extends zio.aws.computeoptimizer.model.Summary.ReadOnly {
    override val name: Option[zio.aws.computeoptimizer.model.Finding] = scala
      .Option(impl.name())
      .map(value => zio.aws.computeoptimizer.model.Finding.wrap(value))
    override val value: Option[SummaryValue] = scala
      .Option(impl.value())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.SummaryValue(value)
      )
    override val reasonCodeSummaries: Option[
      List[zio.aws.computeoptimizer.model.ReasonCodeSummary.ReadOnly]
    ] = scala
      .Option(impl.reasonCodeSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.ReasonCodeSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.Summary
  ): zio.aws.computeoptimizer.model.Summary.ReadOnly = new Wrapper(impl)
}
