package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.computeoptimizer.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class GetLambdaFunctionRecommendationsResponse(
    nextToken: Option[NextToken] = None,
    lambdaFunctionRecommendations: Option[
      Iterable[zio.aws.computeoptimizer.model.LambdaFunctionRecommendation]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.GetLambdaFunctionRecommendationsResponse = {
    import GetLambdaFunctionRecommendationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.GetLambdaFunctionRecommendationsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        lambdaFunctionRecommendations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lambdaFunctionRecommendations)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.GetLambdaFunctionRecommendationsResponse.ReadOnly =
    zio.aws.computeoptimizer.model.GetLambdaFunctionRecommendationsResponse
      .wrap(buildAwsValue())
}
object GetLambdaFunctionRecommendationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.GetLambdaFunctionRecommendationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.GetLambdaFunctionRecommendationsResponse =
      zio.aws.computeoptimizer.model.GetLambdaFunctionRecommendationsResponse(
        nextToken.map(value => value),
        lambdaFunctionRecommendations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextToken]
    def lambdaFunctionRecommendations: Option[
      List[zio.aws.computeoptimizer.model.LambdaFunctionRecommendation.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getLambdaFunctionRecommendations: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.LambdaFunctionRecommendation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "lambdaFunctionRecommendations",
      lambdaFunctionRecommendations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetLambdaFunctionRecommendationsResponse
  ) extends zio.aws.computeoptimizer.model.GetLambdaFunctionRecommendationsResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.computeoptimizer.model.primitives.NextToken(value))
    override val lambdaFunctionRecommendations: Option[
      List[zio.aws.computeoptimizer.model.LambdaFunctionRecommendation.ReadOnly]
    ] = scala
      .Option(impl.lambdaFunctionRecommendations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.LambdaFunctionRecommendation.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetLambdaFunctionRecommendationsResponse
  ): zio.aws.computeoptimizer.model.GetLambdaFunctionRecommendationsResponse.ReadOnly =
    new Wrapper(impl)
}
