package zio.aws.computeoptimizer.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.computeoptimizer.model.primitives.{
  MaxResults,
  NextToken,
  AccountId,
  FunctionArn
}
import scala.jdk.CollectionConverters._
final case class GetLambdaFunctionRecommendationsRequest(
    functionArns: Option[Iterable[FunctionArn]] = None,
    accountIds: Option[Iterable[AccountId]] = None,
    filters: Option[Iterable[
      zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFilter
    ]] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.GetLambdaFunctionRecommendationsRequest = {
    import GetLambdaFunctionRecommendationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.GetLambdaFunctionRecommendationsRequest
      .builder()
      .optionallyWith(
        functionArns.map(value =>
          value.map { item =>
            FunctionArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.functionArns)
      .optionallyWith(
        accountIds.map(value =>
          value.map { item =>
            AccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.accountIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.GetLambdaFunctionRecommendationsRequest.ReadOnly =
    zio.aws.computeoptimizer.model.GetLambdaFunctionRecommendationsRequest
      .wrap(buildAwsValue())
}
object GetLambdaFunctionRecommendationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.GetLambdaFunctionRecommendationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.GetLambdaFunctionRecommendationsRequest =
      zio.aws.computeoptimizer.model.GetLambdaFunctionRecommendationsRequest(
        functionArns.map(value => value),
        accountIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def functionArns: Option[List[FunctionArn]]
    def accountIds: Option[List[AccountId]]
    def filters: Option[List[
      zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFilter.ReadOnly
    ]]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getFunctionArns: ZIO[Any, AwsError, List[FunctionArn]] =
      AwsError.unwrapOptionField("functionArns", functionArns)
    def getAccountIds: ZIO[Any, AwsError, List[AccountId]] =
      AwsError.unwrapOptionField("accountIds", accountIds)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetLambdaFunctionRecommendationsRequest
  ) extends zio.aws.computeoptimizer.model.GetLambdaFunctionRecommendationsRequest.ReadOnly {
    override val functionArns: Option[List[FunctionArn]] = scala
      .Option(impl.functionArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.primitives.FunctionArn(item)
        }.toList
      )
    override val accountIds: Option[List[AccountId]] = scala
      .Option(impl.accountIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.primitives.AccountId(item)
        }.toList
      )
    override val filters: Option[List[
      zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFilter.ReadOnly
    ]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFilter
            .wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.computeoptimizer.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.computeoptimizer.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetLambdaFunctionRecommendationsRequest
  ): zio.aws.computeoptimizer.model.GetLambdaFunctionRecommendationsRequest.ReadOnly =
    new Wrapper(impl)
}
