package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ExportDestination(
    s3: Option[zio.aws.computeoptimizer.model.S3Destination] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.ExportDestination = {
    import ExportDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.ExportDestination
      .builder()
      .optionallyWith(s3.map(value => value.buildAwsValue()))(_.s3)
      .build()
  }
  def asReadOnly: zio.aws.computeoptimizer.model.ExportDestination.ReadOnly =
    zio.aws.computeoptimizer.model.ExportDestination.wrap(buildAwsValue())
}
object ExportDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.ExportDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.computeoptimizer.model.ExportDestination =
      zio.aws.computeoptimizer.model
        .ExportDestination(s3.map(value => value.asEditable))
    def s3: Option[zio.aws.computeoptimizer.model.S3Destination.ReadOnly]
    def getS3: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.S3Destination.ReadOnly
    ] = AwsError.unwrapOptionField("s3", s3)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.ExportDestination
  ) extends zio.aws.computeoptimizer.model.ExportDestination.ReadOnly {
    override val s3
        : Option[zio.aws.computeoptimizer.model.S3Destination.ReadOnly] = scala
      .Option(impl.s3())
      .map(value => zio.aws.computeoptimizer.model.S3Destination.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.ExportDestination
  ): zio.aws.computeoptimizer.model.ExportDestination.ReadOnly = new Wrapper(
    impl
  )
}
