package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteRecommendationPreferencesRequest(
    resourceType: zio.aws.computeoptimizer.model.ResourceType,
    scope: Option[zio.aws.computeoptimizer.model.Scope] = None,
    recommendationPreferenceNames: Iterable[
      zio.aws.computeoptimizer.model.RecommendationPreferenceName
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.DeleteRecommendationPreferencesRequest = {
    import DeleteRecommendationPreferencesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.DeleteRecommendationPreferencesRequest
      .builder()
      .resourceType(resourceType.unwrap)
      .optionallyWith(scope.map(value => value.buildAwsValue()))(_.scope)
      .recommendationPreferenceNamesWithStrings(
        recommendationPreferenceNames.map { item =>
          item.unwrap.toString
        }.asJavaCollection
      )
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.DeleteRecommendationPreferencesRequest.ReadOnly =
    zio.aws.computeoptimizer.model.DeleteRecommendationPreferencesRequest
      .wrap(buildAwsValue())
}
object DeleteRecommendationPreferencesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.DeleteRecommendationPreferencesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.DeleteRecommendationPreferencesRequest =
      zio.aws.computeoptimizer.model.DeleteRecommendationPreferencesRequest(
        resourceType,
        scope.map(value => value.asEditable),
        recommendationPreferenceNames
      )
    def resourceType: zio.aws.computeoptimizer.model.ResourceType
    def scope: Option[zio.aws.computeoptimizer.model.Scope.ReadOnly]
    def recommendationPreferenceNames
        : List[zio.aws.computeoptimizer.model.RecommendationPreferenceName]
    def getResourceType
        : ZIO[Any, Nothing, zio.aws.computeoptimizer.model.ResourceType] =
      ZIO.succeed(resourceType)
    def getScope
        : ZIO[Any, AwsError, zio.aws.computeoptimizer.model.Scope.ReadOnly] =
      AwsError.unwrapOptionField("scope", scope)
    def getRecommendationPreferenceNames: ZIO[Any, Nothing, List[
      zio.aws.computeoptimizer.model.RecommendationPreferenceName
    ]] = ZIO.succeed(recommendationPreferenceNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.DeleteRecommendationPreferencesRequest
  ) extends zio.aws.computeoptimizer.model.DeleteRecommendationPreferencesRequest.ReadOnly {
    override val resourceType: zio.aws.computeoptimizer.model.ResourceType =
      zio.aws.computeoptimizer.model.ResourceType.wrap(impl.resourceType())
    override val scope: Option[zio.aws.computeoptimizer.model.Scope.ReadOnly] =
      scala
        .Option(impl.scope())
        .map(value => zio.aws.computeoptimizer.model.Scope.wrap(value))
    override val recommendationPreferenceNames
        : List[zio.aws.computeoptimizer.model.RecommendationPreferenceName] =
      impl
        .recommendationPreferenceNames()
        .asScala
        .map { item =>
          zio.aws.computeoptimizer.model.RecommendationPreferenceName.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.DeleteRecommendationPreferencesRequest
  ): zio.aws.computeoptimizer.model.DeleteRecommendationPreferencesRequest.ReadOnly =
    new Wrapper(impl)
}
