package zio.aws.computeoptimizer.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.computeoptimizer.model.primitives.{
  VolumeBurstIOPS,
  VolumeSize,
  VolumeBaselineIOPS,
  VolumeBaselineThroughput,
  VolumeBurstThroughput,
  VolumeType
}
import scala.jdk.CollectionConverters._
final case class VolumeConfiguration(
    volumeType: Option[VolumeType] = None,
    volumeSize: Option[VolumeSize] = None,
    volumeBaselineIOPS: Option[VolumeBaselineIOPS] = None,
    volumeBurstIOPS: Option[VolumeBurstIOPS] = None,
    volumeBaselineThroughput: Option[VolumeBaselineThroughput] = None,
    volumeBurstThroughput: Option[VolumeBurstThroughput] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.VolumeConfiguration = {
    import VolumeConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.VolumeConfiguration
      .builder()
      .optionallyWith(
        volumeType.map(value => VolumeType.unwrap(value): java.lang.String)
      )(_.volumeType)
      .optionallyWith(
        volumeSize.map(value => VolumeSize.unwrap(value): Integer)
      )(_.volumeSize)
      .optionallyWith(
        volumeBaselineIOPS.map(value =>
          VolumeBaselineIOPS.unwrap(value): Integer
        )
      )(_.volumeBaselineIOPS)
      .optionallyWith(
        volumeBurstIOPS.map(value => VolumeBurstIOPS.unwrap(value): Integer)
      )(_.volumeBurstIOPS)
      .optionallyWith(
        volumeBaselineThroughput.map(value =>
          VolumeBaselineThroughput.unwrap(value): Integer
        )
      )(_.volumeBaselineThroughput)
      .optionallyWith(
        volumeBurstThroughput.map(value =>
          VolumeBurstThroughput.unwrap(value): Integer
        )
      )(_.volumeBurstThroughput)
      .build()
  }
  def asReadOnly: zio.aws.computeoptimizer.model.VolumeConfiguration.ReadOnly =
    zio.aws.computeoptimizer.model.VolumeConfiguration.wrap(buildAwsValue())
}
object VolumeConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.VolumeConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.computeoptimizer.model.VolumeConfiguration =
      zio.aws.computeoptimizer.model.VolumeConfiguration(
        volumeType.map(value => value),
        volumeSize.map(value => value),
        volumeBaselineIOPS.map(value => value),
        volumeBurstIOPS.map(value => value),
        volumeBaselineThroughput.map(value => value),
        volumeBurstThroughput.map(value => value)
      )
    def volumeType: Option[VolumeType]
    def volumeSize: Option[VolumeSize]
    def volumeBaselineIOPS: Option[VolumeBaselineIOPS]
    def volumeBurstIOPS: Option[VolumeBurstIOPS]
    def volumeBaselineThroughput: Option[VolumeBaselineThroughput]
    def volumeBurstThroughput: Option[VolumeBurstThroughput]
    def getVolumeType: ZIO[Any, AwsError, VolumeType] =
      AwsError.unwrapOptionField("volumeType", volumeType)
    def getVolumeSize: ZIO[Any, AwsError, VolumeSize] =
      AwsError.unwrapOptionField("volumeSize", volumeSize)
    def getVolumeBaselineIOPS: ZIO[Any, AwsError, VolumeBaselineIOPS] =
      AwsError.unwrapOptionField("volumeBaselineIOPS", volumeBaselineIOPS)
    def getVolumeBurstIOPS: ZIO[Any, AwsError, VolumeBurstIOPS] =
      AwsError.unwrapOptionField("volumeBurstIOPS", volumeBurstIOPS)
    def getVolumeBaselineThroughput
        : ZIO[Any, AwsError, VolumeBaselineThroughput] = AwsError
      .unwrapOptionField("volumeBaselineThroughput", volumeBaselineThroughput)
    def getVolumeBurstThroughput: ZIO[Any, AwsError, VolumeBurstThroughput] =
      AwsError.unwrapOptionField("volumeBurstThroughput", volumeBurstThroughput)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.VolumeConfiguration
  ) extends zio.aws.computeoptimizer.model.VolumeConfiguration.ReadOnly {
    override val volumeType: Option[VolumeType] = scala
      .Option(impl.volumeType())
      .map(value => zio.aws.computeoptimizer.model.primitives.VolumeType(value))
    override val volumeSize: Option[VolumeSize] = scala
      .Option(impl.volumeSize())
      .map(value => zio.aws.computeoptimizer.model.primitives.VolumeSize(value))
    override val volumeBaselineIOPS: Option[VolumeBaselineIOPS] = scala
      .Option(impl.volumeBaselineIOPS())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.VolumeBaselineIOPS(value)
      )
    override val volumeBurstIOPS: Option[VolumeBurstIOPS] = scala
      .Option(impl.volumeBurstIOPS())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.VolumeBurstIOPS(value)
      )
    override val volumeBaselineThroughput: Option[VolumeBaselineThroughput] =
      scala
        .Option(impl.volumeBaselineThroughput())
        .map(value =>
          zio.aws.computeoptimizer.model.primitives
            .VolumeBaselineThroughput(value)
        )
    override val volumeBurstThroughput: Option[VolumeBurstThroughput] = scala
      .Option(impl.volumeBurstThroughput())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.VolumeBurstThroughput(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.VolumeConfiguration
  ): zio.aws.computeoptimizer.model.VolumeConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
