package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters._
sealed trait InferredWorkloadType {
  def unwrap: software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadType
}
object InferredWorkloadType {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadType
  ): zio.aws.computeoptimizer.model.InferredWorkloadType = value match {
    case software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadType.AMAZON_EMR =>
      val r = AmazonEmr
      r
    case software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadType.APACHE_CASSANDRA =>
      val r = ApacheCassandra
      r
    case software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadType.APACHE_HADOOP =>
      val r = ApacheHadoop
      r
    case software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadType.MEMCACHED =>
      val r = Memcached
      r
    case software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadType.NGINX =>
      val r = Nginx
      r
    case software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadType.POSTGRE_SQL =>
      val r = PostgreSql
      r
    case software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadType.REDIS =>
      val r = Redis
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.InferredWorkloadType {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadType =
      software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadType.UNKNOWN_TO_SDK_VERSION
  }
  case object AmazonEmr
      extends zio.aws.computeoptimizer.model.InferredWorkloadType {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadType =
      software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadType.AMAZON_EMR
  }
  case object ApacheCassandra
      extends zio.aws.computeoptimizer.model.InferredWorkloadType {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadType =
      software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadType.APACHE_CASSANDRA
  }
  case object ApacheHadoop
      extends zio.aws.computeoptimizer.model.InferredWorkloadType {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadType =
      software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadType.APACHE_HADOOP
  }
  case object Memcached
      extends zio.aws.computeoptimizer.model.InferredWorkloadType {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadType =
      software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadType.MEMCACHED
  }
  case object Nginx
      extends zio.aws.computeoptimizer.model.InferredWorkloadType {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadType =
      software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadType.NGINX
  }
  case object PostgreSql
      extends zio.aws.computeoptimizer.model.InferredWorkloadType {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadType =
      software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadType.POSTGRE_SQL
  }
  case object Redis
      extends zio.aws.computeoptimizer.model.InferredWorkloadType {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadType =
      software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadType.REDIS
  }
}
