package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.computeoptimizer.model.primitives.{VeryLow, Low, Medium, High}
import scala.jdk.CollectionConverters._
final case class CurrentPerformanceRiskRatings(
    high: Option[High] = None,
    medium: Option[Medium] = None,
    low: Option[Low] = None,
    veryLow: Option[VeryLow] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.CurrentPerformanceRiskRatings = {
    import CurrentPerformanceRiskRatings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.CurrentPerformanceRiskRatings
      .builder()
      .optionallyWith(high.map(value => High.unwrap(value): java.lang.Long))(
        _.high
      )
      .optionallyWith(
        medium.map(value => Medium.unwrap(value): java.lang.Long)
      )(_.medium)
      .optionallyWith(low.map(value => Low.unwrap(value): java.lang.Long))(
        _.low
      )
      .optionallyWith(
        veryLow.map(value => VeryLow.unwrap(value): java.lang.Long)
      )(_.veryLow)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.CurrentPerformanceRiskRatings.ReadOnly =
    zio.aws.computeoptimizer.model.CurrentPerformanceRiskRatings
      .wrap(buildAwsValue())
}
object CurrentPerformanceRiskRatings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.CurrentPerformanceRiskRatings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.CurrentPerformanceRiskRatings =
      zio.aws.computeoptimizer.model.CurrentPerformanceRiskRatings(
        high.map(value => value),
        medium.map(value => value),
        low.map(value => value),
        veryLow.map(value => value)
      )
    def high: Option[High]
    def medium: Option[Medium]
    def low: Option[Low]
    def veryLow: Option[VeryLow]
    def getHigh: ZIO[Any, AwsError, High] =
      AwsError.unwrapOptionField("high", high)
    def getMedium: ZIO[Any, AwsError, Medium] =
      AwsError.unwrapOptionField("medium", medium)
    def getLow: ZIO[Any, AwsError, Low] = AwsError.unwrapOptionField("low", low)
    def getVeryLow: ZIO[Any, AwsError, VeryLow] =
      AwsError.unwrapOptionField("veryLow", veryLow)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.CurrentPerformanceRiskRatings
  ) extends zio.aws.computeoptimizer.model.CurrentPerformanceRiskRatings.ReadOnly {
    override val high: Option[High] = scala
      .Option(impl.high())
      .map(value => zio.aws.computeoptimizer.model.primitives.High(value))
    override val medium: Option[Medium] = scala
      .Option(impl.medium())
      .map(value => zio.aws.computeoptimizer.model.primitives.Medium(value))
    override val low: Option[Low] = scala
      .Option(impl.low())
      .map(value => zio.aws.computeoptimizer.model.primitives.Low(value))
    override val veryLow: Option[VeryLow] = scala
      .Option(impl.veryLow())
      .map(value => zio.aws.computeoptimizer.model.primitives.VeryLow(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.CurrentPerformanceRiskRatings
  ): zio.aws.computeoptimizer.model.CurrentPerformanceRiskRatings.ReadOnly =
    new Wrapper(impl)
}
