package zio.aws.computeoptimizer.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.computeoptimizer.model.primitives.{
  Rank,
  PerformanceRisk,
  InstanceType
}
import scala.jdk.CollectionConverters._
final case class InstanceRecommendationOption(
    instanceType: Option[InstanceType] = None,
    projectedUtilizationMetrics: Option[
      Iterable[zio.aws.computeoptimizer.model.UtilizationMetric]
    ] = None,
    platformDifferences: Option[
      Iterable[zio.aws.computeoptimizer.model.PlatformDifference]
    ] = None,
    performanceRisk: Option[PerformanceRisk] = None,
    rank: Option[Rank] = None,
    savingsOpportunity: Option[
      zio.aws.computeoptimizer.model.SavingsOpportunity
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationOption = {
    import InstanceRecommendationOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationOption
      .builder()
      .optionallyWith(
        instanceType.map(value => InstanceType.unwrap(value): java.lang.String)
      )(_.instanceType)
      .optionallyWith(
        projectedUtilizationMetrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.projectedUtilizationMetrics)
      .optionallyWith(
        platformDifferences.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.platformDifferencesWithStrings)
      .optionallyWith(
        performanceRisk.map(value =>
          PerformanceRisk.unwrap(value): java.lang.Double
        )
      )(_.performanceRisk)
      .optionallyWith(rank.map(value => Rank.unwrap(value): Integer))(_.rank)
      .optionallyWith(savingsOpportunity.map(value => value.buildAwsValue()))(
        _.savingsOpportunity
      )
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.InstanceRecommendationOption.ReadOnly =
    zio.aws.computeoptimizer.model.InstanceRecommendationOption
      .wrap(buildAwsValue())
}
object InstanceRecommendationOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.InstanceRecommendationOption =
      zio.aws.computeoptimizer.model.InstanceRecommendationOption(
        instanceType.map(value => value),
        projectedUtilizationMetrics.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        platformDifferences.map(value => value),
        performanceRisk.map(value => value),
        rank.map(value => value),
        savingsOpportunity.map(value => value.asEditable)
      )
    def instanceType: Option[InstanceType]
    def projectedUtilizationMetrics: Option[
      List[zio.aws.computeoptimizer.model.UtilizationMetric.ReadOnly]
    ]
    def platformDifferences
        : Option[List[zio.aws.computeoptimizer.model.PlatformDifference]]
    def performanceRisk: Option[PerformanceRisk]
    def rank: Option[Rank]
    def savingsOpportunity
        : Option[zio.aws.computeoptimizer.model.SavingsOpportunity.ReadOnly]
    def getInstanceType: ZIO[Any, AwsError, InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getProjectedUtilizationMetrics: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.UtilizationMetric.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "projectedUtilizationMetrics",
      projectedUtilizationMetrics
    )
    def getPlatformDifferences: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.PlatformDifference
    ]] = AwsError.unwrapOptionField("platformDifferences", platformDifferences)
    def getPerformanceRisk: ZIO[Any, AwsError, PerformanceRisk] =
      AwsError.unwrapOptionField("performanceRisk", performanceRisk)
    def getRank: ZIO[Any, AwsError, Rank] =
      AwsError.unwrapOptionField("rank", rank)
    def getSavingsOpportunity: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.SavingsOpportunity.ReadOnly
    ] = AwsError.unwrapOptionField("savingsOpportunity", savingsOpportunity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationOption
  ) extends zio.aws.computeoptimizer.model.InstanceRecommendationOption.ReadOnly {
    override val instanceType: Option[InstanceType] = scala
      .Option(impl.instanceType())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.InstanceType(value)
      )
    override val projectedUtilizationMetrics: Option[
      List[zio.aws.computeoptimizer.model.UtilizationMetric.ReadOnly]
    ] = scala
      .Option(impl.projectedUtilizationMetrics())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.UtilizationMetric.wrap(item)
        }.toList
      )
    override val platformDifferences
        : Option[List[zio.aws.computeoptimizer.model.PlatformDifference]] =
      scala
        .Option(impl.platformDifferences())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.computeoptimizer.model.PlatformDifference.wrap(item)
          }.toList
        )
    override val performanceRisk: Option[PerformanceRisk] = scala
      .Option(impl.performanceRisk())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.PerformanceRisk(value)
      )
    override val rank: Option[Rank] = scala
      .Option(impl.rank())
      .map(value => zio.aws.computeoptimizer.model.primitives.Rank(value))
    override val savingsOpportunity
        : Option[zio.aws.computeoptimizer.model.SavingsOpportunity.ReadOnly] =
      scala
        .Option(impl.savingsOpportunity())
        .map(value =>
          zio.aws.computeoptimizer.model.SavingsOpportunity.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationOption
  ): zio.aws.computeoptimizer.model.InstanceRecommendationOption.ReadOnly =
    new Wrapper(impl)
}
