package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.computeoptimizer.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class GetAutoScalingGroupRecommendationsResponse(
    nextToken: Option[NextToken] = None,
    autoScalingGroupRecommendations: Option[
      Iterable[zio.aws.computeoptimizer.model.AutoScalingGroupRecommendation]
    ] = None,
    errors: Option[
      Iterable[zio.aws.computeoptimizer.model.GetRecommendationError]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.GetAutoScalingGroupRecommendationsResponse = {
    import GetAutoScalingGroupRecommendationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.GetAutoScalingGroupRecommendationsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        autoScalingGroupRecommendations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.autoScalingGroupRecommendations)
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.GetAutoScalingGroupRecommendationsResponse.ReadOnly =
    zio.aws.computeoptimizer.model.GetAutoScalingGroupRecommendationsResponse
      .wrap(buildAwsValue())
}
object GetAutoScalingGroupRecommendationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.GetAutoScalingGroupRecommendationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.GetAutoScalingGroupRecommendationsResponse =
      zio.aws.computeoptimizer.model.GetAutoScalingGroupRecommendationsResponse(
        nextToken.map(value => value),
        autoScalingGroupRecommendations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextToken]
    def autoScalingGroupRecommendations: Option[List[
      zio.aws.computeoptimizer.model.AutoScalingGroupRecommendation.ReadOnly
    ]]
    def errors: Option[
      List[zio.aws.computeoptimizer.model.GetRecommendationError.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getAutoScalingGroupRecommendations: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.AutoScalingGroupRecommendation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "autoScalingGroupRecommendations",
      autoScalingGroupRecommendations
    )
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.GetRecommendationError.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetAutoScalingGroupRecommendationsResponse
  ) extends zio.aws.computeoptimizer.model.GetAutoScalingGroupRecommendationsResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.computeoptimizer.model.primitives.NextToken(value))
    override val autoScalingGroupRecommendations: Option[List[
      zio.aws.computeoptimizer.model.AutoScalingGroupRecommendation.ReadOnly
    ]] = scala
      .Option(impl.autoScalingGroupRecommendations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.AutoScalingGroupRecommendation
            .wrap(item)
        }.toList
      )
    override val errors: Option[
      List[zio.aws.computeoptimizer.model.GetRecommendationError.ReadOnly]
    ] = scala
      .Option(impl.errors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.GetRecommendationError.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetAutoScalingGroupRecommendationsResponse
  ): zio.aws.computeoptimizer.model.GetAutoScalingGroupRecommendationsResponse.ReadOnly =
    new Wrapper(impl)
}
