package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters._
sealed trait ECSServiceMetricName {
  def unwrap: software.amazon.awssdk.services.computeoptimizer.model.ECSServiceMetricName
}
object ECSServiceMetricName {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.ECSServiceMetricName
  ): zio.aws.computeoptimizer.model.ECSServiceMetricName = value match {
    case software.amazon.awssdk.services.computeoptimizer.model.ECSServiceMetricName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ECSServiceMetricName.CPU =>
      val r = Cpu
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ECSServiceMetricName.MEMORY =>
      val r = Memory
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.ECSServiceMetricName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ECSServiceMetricName =
      software.amazon.awssdk.services.computeoptimizer.model.ECSServiceMetricName.UNKNOWN_TO_SDK_VERSION
  }
  case object Cpu extends zio.aws.computeoptimizer.model.ECSServiceMetricName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ECSServiceMetricName =
      software.amazon.awssdk.services.computeoptimizer.model.ECSServiceMetricName.CPU
  }
  case object Memory
      extends zio.aws.computeoptimizer.model.ECSServiceMetricName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ECSServiceMetricName =
      software.amazon.awssdk.services.computeoptimizer.model.ECSServiceMetricName.MEMORY
  }
}
