package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters._
sealed trait ExternalMetricsSource {
  def unwrap: software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricsSource
}
object ExternalMetricsSource {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricsSource
  ): zio.aws.computeoptimizer.model.ExternalMetricsSource = value match {
    case software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricsSource.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricsSource.DATADOG =>
      val r = Datadog
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricsSource.DYNATRACE =>
      val r = Dynatrace
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricsSource.NEW_RELIC =>
      val r = NewRelic
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricsSource.INSTANA =>
      val r = Instana
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.ExternalMetricsSource {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricsSource =
      software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricsSource.UNKNOWN_TO_SDK_VERSION
  }
  case object Datadog
      extends zio.aws.computeoptimizer.model.ExternalMetricsSource {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricsSource =
      software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricsSource.DATADOG
  }
  case object Dynatrace
      extends zio.aws.computeoptimizer.model.ExternalMetricsSource {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricsSource =
      software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricsSource.DYNATRACE
  }
  case object NewRelic
      extends zio.aws.computeoptimizer.model.ExternalMetricsSource {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricsSource =
      software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricsSource.NEW_RELIC
  }
  case object Instana
      extends zio.aws.computeoptimizer.model.ExternalMetricsSource {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricsSource =
      software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricsSource.INSTANA
  }
}
