package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.computeoptimizer.model.primitives.{
  MetadataKey,
  DestinationKey,
  DestinationBucket
}
import scala.jdk.CollectionConverters._
final case class S3Destination(
    bucket: Optional[DestinationBucket] = Optional.Absent,
    key: Optional[DestinationKey] = Optional.Absent,
    metadataKey: Optional[MetadataKey] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.S3Destination = {
    import S3Destination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.S3Destination
      .builder()
      .optionallyWith(
        bucket.map(value => DestinationBucket.unwrap(value): java.lang.String)
      )(_.bucket)
      .optionallyWith(
        key.map(value => DestinationKey.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        metadataKey.map(value => MetadataKey.unwrap(value): java.lang.String)
      )(_.metadataKey)
      .build()
  }
  def asReadOnly: zio.aws.computeoptimizer.model.S3Destination.ReadOnly =
    zio.aws.computeoptimizer.model.S3Destination.wrap(buildAwsValue())
}
object S3Destination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.S3Destination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.computeoptimizer.model.S3Destination =
      zio.aws.computeoptimizer.model.S3Destination(
        bucket.map(value => value),
        key.map(value => value),
        metadataKey.map(value => value)
      )
    def bucket: Optional[DestinationBucket]
    def key: Optional[DestinationKey]
    def metadataKey: Optional[MetadataKey]
    def getBucket: ZIO[Any, AwsError, DestinationBucket] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getKey: ZIO[Any, AwsError, DestinationKey] =
      AwsError.unwrapOptionField("key", key)
    def getMetadataKey: ZIO[Any, AwsError, MetadataKey] =
      AwsError.unwrapOptionField("metadataKey", metadataKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.S3Destination
  ) extends zio.aws.computeoptimizer.model.S3Destination.ReadOnly {
    override val bucket: Optional[DestinationBucket] = zio.aws.core.internal
      .optionalFromNullable(impl.bucket())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.DestinationBucket(value)
      )
    override val key: Optional[DestinationKey] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.DestinationKey(value)
      )
    override val metadataKey: Optional[MetadataKey] = zio.aws.core.internal
      .optionalFromNullable(impl.metadataKey())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.MetadataKey(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.S3Destination
  ): zio.aws.computeoptimizer.model.S3Destination.ReadOnly = new Wrapper(impl)
}
