package zio.aws.computeoptimizer.model
import zio.aws.computeoptimizer.model.primitives.{MetricValue, Timestamp}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ProjectedMetric(
    name: Optional[zio.aws.computeoptimizer.model.MetricName] = Optional.Absent,
    timestamps: Optional[Iterable[Timestamp]] = Optional.Absent,
    values: Optional[Iterable[MetricValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.ProjectedMetric = {
    import ProjectedMetric.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.ProjectedMetric
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(
        timestamps.map(value =>
          value.map { item =>
            Timestamp.unwrap(item): Instant
          }.asJavaCollection
        )
      )(_.timestamps)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            MetricValue.unwrap(item): java.lang.Double
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly: zio.aws.computeoptimizer.model.ProjectedMetric.ReadOnly =
    zio.aws.computeoptimizer.model.ProjectedMetric.wrap(buildAwsValue())
}
object ProjectedMetric {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.ProjectedMetric
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.computeoptimizer.model.ProjectedMetric =
      zio.aws.computeoptimizer.model.ProjectedMetric(
        name.map(value => value),
        timestamps.map(value => value),
        values.map(value => value)
      )
    def name: Optional[zio.aws.computeoptimizer.model.MetricName]
    def timestamps: Optional[List[Timestamp]]
    def values: Optional[List[MetricValue]]
    def getName: ZIO[Any, AwsError, zio.aws.computeoptimizer.model.MetricName] =
      AwsError.unwrapOptionField("name", name)
    def getTimestamps: ZIO[Any, AwsError, List[Timestamp]] =
      AwsError.unwrapOptionField("timestamps", timestamps)
    def getValues: ZIO[Any, AwsError, List[MetricValue]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.ProjectedMetric
  ) extends zio.aws.computeoptimizer.model.ProjectedMetric.ReadOnly {
    override val name: Optional[zio.aws.computeoptimizer.model.MetricName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value => zio.aws.computeoptimizer.model.MetricName.wrap(value))
    override val timestamps: Optional[List[Timestamp]] = zio.aws.core.internal
      .optionalFromNullable(impl.timestamps())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.primitives.Timestamp(item)
        }.toList
      )
    override val values: Optional[List[MetricValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.values())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.primitives.MetricValue(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.ProjectedMetric
  ): zio.aws.computeoptimizer.model.ProjectedMetric.ReadOnly = new Wrapper(impl)
}
