package zio.aws.computeoptimizer.model
import zio.aws.computeoptimizer.model.primitives.{
  AccountId,
  MaxResults,
  NextToken,
  InstanceArn
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetEc2InstanceRecommendationsRequest(
    instanceArns: Optional[Iterable[InstanceArn]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.computeoptimizer.model.Filter]] =
      Optional.Absent,
    accountIds: Optional[Iterable[AccountId]] = Optional.Absent,
    recommendationPreferences: Optional[
      zio.aws.computeoptimizer.model.RecommendationPreferences
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.GetEc2InstanceRecommendationsRequest = {
    import GetEc2InstanceRecommendationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.GetEc2InstanceRecommendationsRequest
      .builder()
      .optionallyWith(
        instanceArns.map(value =>
          value.map { item =>
            InstanceArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.instanceArns)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        accountIds.map(value =>
          value.map { item =>
            AccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.accountIds)
      .optionallyWith(
        recommendationPreferences.map(value => value.buildAwsValue())
      )(_.recommendationPreferences)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.GetEc2InstanceRecommendationsRequest.ReadOnly =
    zio.aws.computeoptimizer.model.GetEc2InstanceRecommendationsRequest
      .wrap(buildAwsValue())
}
object GetEc2InstanceRecommendationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.GetEc2InstanceRecommendationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.GetEc2InstanceRecommendationsRequest =
      zio.aws.computeoptimizer.model.GetEc2InstanceRecommendationsRequest(
        instanceArns.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        accountIds.map(value => value),
        recommendationPreferences.map(value => value.asEditable)
      )
    def instanceArns: Optional[List[InstanceArn]]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def filters: Optional[List[zio.aws.computeoptimizer.model.Filter.ReadOnly]]
    def accountIds: Optional[List[AccountId]]
    def recommendationPreferences: Optional[
      zio.aws.computeoptimizer.model.RecommendationPreferences.ReadOnly
    ]
    def getInstanceArns: ZIO[Any, AwsError, List[InstanceArn]] =
      AwsError.unwrapOptionField("instanceArns", instanceArns)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.Filter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getAccountIds: ZIO[Any, AwsError, List[AccountId]] =
      AwsError.unwrapOptionField("accountIds", accountIds)
    def getRecommendationPreferences: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.RecommendationPreferences.ReadOnly
    ] = AwsError.unwrapOptionField(
      "recommendationPreferences",
      recommendationPreferences
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetEc2InstanceRecommendationsRequest
  ) extends zio.aws.computeoptimizer.model.GetEc2InstanceRecommendationsRequest.ReadOnly {
    override val instanceArns: Optional[List[InstanceArn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.computeoptimizer.model.primitives.InstanceArn(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.computeoptimizer.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.computeoptimizer.model.primitives.MaxResults(value))
    override val filters
        : Optional[List[zio.aws.computeoptimizer.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.computeoptimizer.model.Filter.wrap(item)
          }.toList
        )
    override val accountIds: Optional[List[AccountId]] = zio.aws.core.internal
      .optionalFromNullable(impl.accountIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.primitives.AccountId(item)
        }.toList
      )
    override val recommendationPreferences: Optional[
      zio.aws.computeoptimizer.model.RecommendationPreferences.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.recommendationPreferences())
      .map(value =>
        zio.aws.computeoptimizer.model.RecommendationPreferences.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetEc2InstanceRecommendationsRequest
  ): zio.aws.computeoptimizer.model.GetEc2InstanceRecommendationsRequest.ReadOnly =
    new Wrapper(impl)
}
