package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters._
sealed trait FileFormat {
  def unwrap: software.amazon.awssdk.services.computeoptimizer.model.FileFormat
}
object FileFormat {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.FileFormat
  ): zio.aws.computeoptimizer.model.FileFormat = value match {
    case software.amazon.awssdk.services.computeoptimizer.model.FileFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.computeoptimizer.model.FileFormat.CSV =>
      val r = Csv
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.FileFormat {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.FileFormat =
      software.amazon.awssdk.services.computeoptimizer.model.FileFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object Csv extends zio.aws.computeoptimizer.model.FileFormat {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.FileFormat =
      software.amazon.awssdk.services.computeoptimizer.model.FileFormat.CSV
  }
}
