package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters._
sealed trait ExportableLambdaFunctionField {
  def unwrap: software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField
}
object ExportableLambdaFunctionField {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField
  ): zio.aws.computeoptimizer.model.ExportableLambdaFunctionField =
    value match {
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.ACCOUNT_ID =>
        val r = AccountId
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.FUNCTION_ARN =>
        val r = FunctionArn
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.FUNCTION_VERSION =>
        val r = FunctionVersion
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.FINDING =>
        val r = Finding
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.FINDING_REASON_CODES =>
        val r = FindingReasonCodes
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.NUMBER_OF_INVOCATIONS =>
        val r = NumberOfInvocations
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.UTILIZATION_METRICS_DURATION_MAXIMUM =>
        val r = UtilizationMetricsDurationMaximum
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.UTILIZATION_METRICS_DURATION_AVERAGE =>
        val r = UtilizationMetricsDurationAverage
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.UTILIZATION_METRICS_MEMORY_MAXIMUM =>
        val r = UtilizationMetricsMemoryMaximum
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.UTILIZATION_METRICS_MEMORY_AVERAGE =>
        val r = UtilizationMetricsMemoryAverage
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.LOOKBACK_PERIOD_IN_DAYS =>
        val r = LookbackPeriodInDays
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.CURRENT_CONFIGURATION_MEMORY_SIZE =>
        val r = CurrentConfigurationMemorySize
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.CURRENT_CONFIGURATION_TIMEOUT =>
        val r = CurrentConfigurationTimeout
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.CURRENT_COST_TOTAL =>
        val r = CurrentCostTotal
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.CURRENT_COST_AVERAGE =>
        val r = CurrentCostAverage
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.RECOMMENDATION_OPTIONS_CONFIGURATION_MEMORY_SIZE =>
        val r = RecommendationOptionsConfigurationMemorySize
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.RECOMMENDATION_OPTIONS_COST_LOW =>
        val r = RecommendationOptionsCostLow
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.RECOMMENDATION_OPTIONS_COST_HIGH =>
        val r = RecommendationOptionsCostHigh
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.RECOMMENDATION_OPTIONS_PROJECTED_UTILIZATION_METRICS_DURATION_LOWER_BOUND =>
        val r =
          RecommendationOptionsProjectedUtilizationMetricsDurationLowerBound
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.RECOMMENDATION_OPTIONS_PROJECTED_UTILIZATION_METRICS_DURATION_UPPER_BOUND =>
        val r =
          RecommendationOptionsProjectedUtilizationMetricsDurationUpperBound
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.RECOMMENDATION_OPTIONS_PROJECTED_UTILIZATION_METRICS_DURATION_EXPECTED =>
        val r = RecommendationOptionsProjectedUtilizationMetricsDurationExpected
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.LAST_REFRESH_TIMESTAMP =>
        val r = LastRefreshTimestamp
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.CURRENT_PERFORMANCE_RISK =>
        val r = CurrentPerformanceRisk
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.RECOMMENDATION_OPTIONS_SAVINGS_OPPORTUNITY_PERCENTAGE =>
        val r = RecommendationOptionsSavingsOpportunityPercentage
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_CURRENCY =>
        val r = RecommendationOptionsEstimatedMonthlySavingsCurrency
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_VALUE =>
        val r = RecommendationOptionsEstimatedMonthlySavingsValue
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.ExportableLambdaFunctionField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.UNKNOWN_TO_SDK_VERSION
  }
  case object AccountId
      extends zio.aws.computeoptimizer.model.ExportableLambdaFunctionField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.ACCOUNT_ID
  }
  case object FunctionArn
      extends zio.aws.computeoptimizer.model.ExportableLambdaFunctionField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.FUNCTION_ARN
  }
  case object FunctionVersion
      extends zio.aws.computeoptimizer.model.ExportableLambdaFunctionField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.FUNCTION_VERSION
  }
  case object Finding
      extends zio.aws.computeoptimizer.model.ExportableLambdaFunctionField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.FINDING
  }
  case object FindingReasonCodes
      extends zio.aws.computeoptimizer.model.ExportableLambdaFunctionField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.FINDING_REASON_CODES
  }
  case object NumberOfInvocations
      extends zio.aws.computeoptimizer.model.ExportableLambdaFunctionField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.NUMBER_OF_INVOCATIONS
  }
  case object UtilizationMetricsDurationMaximum
      extends zio.aws.computeoptimizer.model.ExportableLambdaFunctionField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.UTILIZATION_METRICS_DURATION_MAXIMUM
  }
  case object UtilizationMetricsDurationAverage
      extends zio.aws.computeoptimizer.model.ExportableLambdaFunctionField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.UTILIZATION_METRICS_DURATION_AVERAGE
  }
  case object UtilizationMetricsMemoryMaximum
      extends zio.aws.computeoptimizer.model.ExportableLambdaFunctionField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.UTILIZATION_METRICS_MEMORY_MAXIMUM
  }
  case object UtilizationMetricsMemoryAverage
      extends zio.aws.computeoptimizer.model.ExportableLambdaFunctionField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.UTILIZATION_METRICS_MEMORY_AVERAGE
  }
  case object LookbackPeriodInDays
      extends zio.aws.computeoptimizer.model.ExportableLambdaFunctionField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.LOOKBACK_PERIOD_IN_DAYS
  }
  case object CurrentConfigurationMemorySize
      extends zio.aws.computeoptimizer.model.ExportableLambdaFunctionField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.CURRENT_CONFIGURATION_MEMORY_SIZE
  }
  case object CurrentConfigurationTimeout
      extends zio.aws.computeoptimizer.model.ExportableLambdaFunctionField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.CURRENT_CONFIGURATION_TIMEOUT
  }
  case object CurrentCostTotal
      extends zio.aws.computeoptimizer.model.ExportableLambdaFunctionField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.CURRENT_COST_TOTAL
  }
  case object CurrentCostAverage
      extends zio.aws.computeoptimizer.model.ExportableLambdaFunctionField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.CURRENT_COST_AVERAGE
  }
  case object RecommendationOptionsConfigurationMemorySize
      extends zio.aws.computeoptimizer.model.ExportableLambdaFunctionField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.RECOMMENDATION_OPTIONS_CONFIGURATION_MEMORY_SIZE
  }
  case object RecommendationOptionsCostLow
      extends zio.aws.computeoptimizer.model.ExportableLambdaFunctionField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.RECOMMENDATION_OPTIONS_COST_LOW
  }
  case object RecommendationOptionsCostHigh
      extends zio.aws.computeoptimizer.model.ExportableLambdaFunctionField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.RECOMMENDATION_OPTIONS_COST_HIGH
  }
  case object RecommendationOptionsProjectedUtilizationMetricsDurationLowerBound
      extends zio.aws.computeoptimizer.model.ExportableLambdaFunctionField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.RECOMMENDATION_OPTIONS_PROJECTED_UTILIZATION_METRICS_DURATION_LOWER_BOUND
  }
  case object RecommendationOptionsProjectedUtilizationMetricsDurationUpperBound
      extends zio.aws.computeoptimizer.model.ExportableLambdaFunctionField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.RECOMMENDATION_OPTIONS_PROJECTED_UTILIZATION_METRICS_DURATION_UPPER_BOUND
  }
  case object RecommendationOptionsProjectedUtilizationMetricsDurationExpected
      extends zio.aws.computeoptimizer.model.ExportableLambdaFunctionField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.RECOMMENDATION_OPTIONS_PROJECTED_UTILIZATION_METRICS_DURATION_EXPECTED
  }
  case object LastRefreshTimestamp
      extends zio.aws.computeoptimizer.model.ExportableLambdaFunctionField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.LAST_REFRESH_TIMESTAMP
  }
  case object CurrentPerformanceRisk
      extends zio.aws.computeoptimizer.model.ExportableLambdaFunctionField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.CURRENT_PERFORMANCE_RISK
  }
  case object RecommendationOptionsSavingsOpportunityPercentage
      extends zio.aws.computeoptimizer.model.ExportableLambdaFunctionField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.RECOMMENDATION_OPTIONS_SAVINGS_OPPORTUNITY_PERCENTAGE
  }
  case object RecommendationOptionsEstimatedMonthlySavingsCurrency
      extends zio.aws.computeoptimizer.model.ExportableLambdaFunctionField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_CURRENCY
  }
  case object RecommendationOptionsEstimatedMonthlySavingsValue
      extends zio.aws.computeoptimizer.model.ExportableLambdaFunctionField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableLambdaFunctionField.RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_VALUE
  }
}
