package zio.aws.computeoptimizer.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.computeoptimizer.model.primitives.{MaxResults, NextToken}
import scala.jdk.CollectionConverters._
final case class GetRecommendationPreferencesRequest(
    resourceType: zio.aws.computeoptimizer.model.ResourceType,
    scope: Option[zio.aws.computeoptimizer.model.Scope] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationPreferencesRequest = {
    import GetRecommendationPreferencesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationPreferencesRequest
      .builder()
      .resourceType(resourceType.unwrap)
      .optionallyWith(scope.map(value => value.buildAwsValue()))(_.scope)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.GetRecommendationPreferencesRequest.ReadOnly =
    zio.aws.computeoptimizer.model.GetRecommendationPreferencesRequest
      .wrap(buildAwsValue())
}
object GetRecommendationPreferencesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationPreferencesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.GetRecommendationPreferencesRequest =
      zio.aws.computeoptimizer.model.GetRecommendationPreferencesRequest(
        resourceType,
        scope.map(value => value.asEditable),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def resourceType: zio.aws.computeoptimizer.model.ResourceType
    def scope: Option[zio.aws.computeoptimizer.model.Scope.ReadOnly]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getResourceType
        : ZIO[Any, Nothing, zio.aws.computeoptimizer.model.ResourceType] =
      ZIO.succeed(resourceType)
    def getScope
        : ZIO[Any, AwsError, zio.aws.computeoptimizer.model.Scope.ReadOnly] =
      AwsError.unwrapOptionField("scope", scope)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationPreferencesRequest
  ) extends zio.aws.computeoptimizer.model.GetRecommendationPreferencesRequest.ReadOnly {
    override val resourceType: zio.aws.computeoptimizer.model.ResourceType =
      zio.aws.computeoptimizer.model.ResourceType.wrap(impl.resourceType())
    override val scope: Option[zio.aws.computeoptimizer.model.Scope.ReadOnly] =
      scala
        .Option(impl.scope())
        .map(value => zio.aws.computeoptimizer.model.Scope.wrap(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.computeoptimizer.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.computeoptimizer.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationPreferencesRequest
  ): zio.aws.computeoptimizer.model.GetRecommendationPreferencesRequest.ReadOnly =
    new Wrapper(impl)
}
