package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.computeoptimizer.model.primitives.MetricValue
import scala.jdk.CollectionConverters._
final case class LambdaFunctionUtilizationMetric(
    name: Option[zio.aws.computeoptimizer.model.LambdaFunctionMetricName] =
      None,
    statistic: Option[
      zio.aws.computeoptimizer.model.LambdaFunctionMetricStatistic
    ] = None,
    value: Option[MetricValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionUtilizationMetric = {
    import LambdaFunctionUtilizationMetric.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionUtilizationMetric
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(statistic.map(value => value.unwrap))(_.statistic)
      .optionallyWith(
        value.map(value => MetricValue.unwrap(value): java.lang.Double)
      )(_.value)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.LambdaFunctionUtilizationMetric.ReadOnly =
    zio.aws.computeoptimizer.model.LambdaFunctionUtilizationMetric
      .wrap(buildAwsValue())
}
object LambdaFunctionUtilizationMetric {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionUtilizationMetric
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.LambdaFunctionUtilizationMetric =
      zio.aws.computeoptimizer.model.LambdaFunctionUtilizationMetric(
        name.map(value => value),
        statistic.map(value => value),
        value.map(value => value)
      )
    def name: Option[zio.aws.computeoptimizer.model.LambdaFunctionMetricName]
    def statistic
        : Option[zio.aws.computeoptimizer.model.LambdaFunctionMetricStatistic]
    def value: Option[MetricValue]
    def getName: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.LambdaFunctionMetricName
    ] = AwsError.unwrapOptionField("name", name)
    def getStatistic: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.LambdaFunctionMetricStatistic
    ] = AwsError.unwrapOptionField("statistic", statistic)
    def getValue: ZIO[Any, AwsError, MetricValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionUtilizationMetric
  ) extends zio.aws.computeoptimizer.model.LambdaFunctionUtilizationMetric.ReadOnly {
    override val name
        : Option[zio.aws.computeoptimizer.model.LambdaFunctionMetricName] =
      scala
        .Option(impl.name())
        .map(value =>
          zio.aws.computeoptimizer.model.LambdaFunctionMetricName.wrap(value)
        )
    override val statistic
        : Option[zio.aws.computeoptimizer.model.LambdaFunctionMetricStatistic] =
      scala
        .Option(impl.statistic())
        .map(value =>
          zio.aws.computeoptimizer.model.LambdaFunctionMetricStatistic
            .wrap(value)
        )
    override val value: Option[MetricValue] = scala
      .Option(impl.value())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.MetricValue(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionUtilizationMetric
  ): zio.aws.computeoptimizer.model.LambdaFunctionUtilizationMetric.ReadOnly =
    new Wrapper(impl)
}
