package zio.aws.computeoptimizer.model
import zio.aws.computeoptimizer.model.primitives.{
  AccountId,
  FunctionVersion,
  MemorySize,
  LastRefreshTimestamp,
  FunctionArn,
  LookBackPeriodInDays,
  NumberOfInvocations
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class LambdaFunctionRecommendation(
    functionArn: Option[FunctionArn] = None,
    functionVersion: Option[FunctionVersion] = None,
    accountId: Option[AccountId] = None,
    currentMemorySize: Option[MemorySize] = None,
    numberOfInvocations: Option[NumberOfInvocations] = None,
    utilizationMetrics: Option[
      Iterable[zio.aws.computeoptimizer.model.LambdaFunctionUtilizationMetric]
    ] = None,
    lookbackPeriodInDays: Option[LookBackPeriodInDays] = None,
    lastRefreshTimestamp: Option[LastRefreshTimestamp] = None,
    finding: Option[
      zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFinding
    ] = None,
    findingReasonCodes: Option[Iterable[
      zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFindingReasonCode
    ]] = None,
    memorySizeRecommendationOptions: Option[Iterable[
      zio.aws.computeoptimizer.model.LambdaFunctionMemoryRecommendationOption
    ]] = None,
    currentPerformanceRisk: Option[
      zio.aws.computeoptimizer.model.CurrentPerformanceRisk
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendation = {
    import LambdaFunctionRecommendation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendation
      .builder()
      .optionallyWith(
        functionArn.map(value => FunctionArn.unwrap(value): java.lang.String)
      )(_.functionArn)
      .optionallyWith(
        functionVersion.map(value =>
          FunctionVersion.unwrap(value): java.lang.String
        )
      )(_.functionVersion)
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        currentMemorySize.map(value => MemorySize.unwrap(value): Integer)
      )(_.currentMemorySize)
      .optionallyWith(
        numberOfInvocations.map(value =>
          NumberOfInvocations.unwrap(value): java.lang.Long
        )
      )(_.numberOfInvocations)
      .optionallyWith(
        utilizationMetrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.utilizationMetrics)
      .optionallyWith(
        lookbackPeriodInDays.map(value =>
          LookBackPeriodInDays.unwrap(value): java.lang.Double
        )
      )(_.lookbackPeriodInDays)
      .optionallyWith(
        lastRefreshTimestamp.map(value =>
          LastRefreshTimestamp.unwrap(value): Instant
        )
      )(_.lastRefreshTimestamp)
      .optionallyWith(finding.map(value => value.unwrap))(_.finding)
      .optionallyWith(
        findingReasonCodes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.findingReasonCodesWithStrings)
      .optionallyWith(
        memorySizeRecommendationOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.memorySizeRecommendationOptions)
      .optionallyWith(currentPerformanceRisk.map(value => value.unwrap))(
        _.currentPerformanceRisk
      )
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.LambdaFunctionRecommendation.ReadOnly =
    zio.aws.computeoptimizer.model.LambdaFunctionRecommendation
      .wrap(buildAwsValue())
}
object LambdaFunctionRecommendation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.LambdaFunctionRecommendation =
      zio.aws.computeoptimizer.model.LambdaFunctionRecommendation(
        functionArn.map(value => value),
        functionVersion.map(value => value),
        accountId.map(value => value),
        currentMemorySize.map(value => value),
        numberOfInvocations.map(value => value),
        utilizationMetrics.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lookbackPeriodInDays.map(value => value),
        lastRefreshTimestamp.map(value => value),
        finding.map(value => value),
        findingReasonCodes.map(value => value),
        memorySizeRecommendationOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        currentPerformanceRisk.map(value => value)
      )
    def functionArn: Option[FunctionArn]
    def functionVersion: Option[FunctionVersion]
    def accountId: Option[AccountId]
    def currentMemorySize: Option[MemorySize]
    def numberOfInvocations: Option[NumberOfInvocations]
    def utilizationMetrics: Option[List[
      zio.aws.computeoptimizer.model.LambdaFunctionUtilizationMetric.ReadOnly
    ]]
    def lookbackPeriodInDays: Option[LookBackPeriodInDays]
    def lastRefreshTimestamp: Option[LastRefreshTimestamp]
    def finding: Option[
      zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFinding
    ]
    def findingReasonCodes: Option[List[
      zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFindingReasonCode
    ]]
    def memorySizeRecommendationOptions: Option[List[
      zio.aws.computeoptimizer.model.LambdaFunctionMemoryRecommendationOption.ReadOnly
    ]]
    def currentPerformanceRisk
        : Option[zio.aws.computeoptimizer.model.CurrentPerformanceRisk]
    def getFunctionArn: ZIO[Any, AwsError, FunctionArn] =
      AwsError.unwrapOptionField("functionArn", functionArn)
    def getFunctionVersion: ZIO[Any, AwsError, FunctionVersion] =
      AwsError.unwrapOptionField("functionVersion", functionVersion)
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getCurrentMemorySize: ZIO[Any, AwsError, MemorySize] =
      AwsError.unwrapOptionField("currentMemorySize", currentMemorySize)
    def getNumberOfInvocations: ZIO[Any, AwsError, NumberOfInvocations] =
      AwsError.unwrapOptionField("numberOfInvocations", numberOfInvocations)
    def getUtilizationMetrics: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.LambdaFunctionUtilizationMetric.ReadOnly
    ]] = AwsError.unwrapOptionField("utilizationMetrics", utilizationMetrics)
    def getLookbackPeriodInDays: ZIO[Any, AwsError, LookBackPeriodInDays] =
      AwsError.unwrapOptionField("lookbackPeriodInDays", lookbackPeriodInDays)
    def getLastRefreshTimestamp: ZIO[Any, AwsError, LastRefreshTimestamp] =
      AwsError.unwrapOptionField("lastRefreshTimestamp", lastRefreshTimestamp)
    def getFinding: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFinding
    ] = AwsError.unwrapOptionField("finding", finding)
    def getFindingReasonCodes: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFindingReasonCode
    ]] = AwsError.unwrapOptionField("findingReasonCodes", findingReasonCodes)
    def getMemorySizeRecommendationOptions: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.LambdaFunctionMemoryRecommendationOption.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "memorySizeRecommendationOptions",
      memorySizeRecommendationOptions
    )
    def getCurrentPerformanceRisk: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.CurrentPerformanceRisk
    ] = AwsError.unwrapOptionField(
      "currentPerformanceRisk",
      currentPerformanceRisk
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendation
  ) extends zio.aws.computeoptimizer.model.LambdaFunctionRecommendation.ReadOnly {
    override val functionArn: Option[FunctionArn] = scala
      .Option(impl.functionArn())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.FunctionArn(value)
      )
    override val functionVersion: Option[FunctionVersion] = scala
      .Option(impl.functionVersion())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.FunctionVersion(value)
      )
    override val accountId: Option[AccountId] = scala
      .Option(impl.accountId())
      .map(value => zio.aws.computeoptimizer.model.primitives.AccountId(value))
    override val currentMemorySize: Option[MemorySize] = scala
      .Option(impl.currentMemorySize())
      .map(value => zio.aws.computeoptimizer.model.primitives.MemorySize(value))
    override val numberOfInvocations: Option[NumberOfInvocations] = scala
      .Option(impl.numberOfInvocations())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.NumberOfInvocations(value)
      )
    override val utilizationMetrics: Option[List[
      zio.aws.computeoptimizer.model.LambdaFunctionUtilizationMetric.ReadOnly
    ]] = scala
      .Option(impl.utilizationMetrics())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.LambdaFunctionUtilizationMetric
            .wrap(item)
        }.toList
      )
    override val lookbackPeriodInDays: Option[LookBackPeriodInDays] = scala
      .Option(impl.lookbackPeriodInDays())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.LookBackPeriodInDays(value)
      )
    override val lastRefreshTimestamp: Option[LastRefreshTimestamp] = scala
      .Option(impl.lastRefreshTimestamp())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.LastRefreshTimestamp(value)
      )
    override val finding: Option[
      zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFinding
    ] = scala
      .Option(impl.finding())
      .map(value =>
        zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFinding
          .wrap(value)
      )
    override val findingReasonCodes: Option[List[
      zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFindingReasonCode
    ]] = scala
      .Option(impl.findingReasonCodes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFindingReasonCode
            .wrap(item)
        }.toList
      )
    override val memorySizeRecommendationOptions: Option[List[
      zio.aws.computeoptimizer.model.LambdaFunctionMemoryRecommendationOption.ReadOnly
    ]] = scala
      .Option(impl.memorySizeRecommendationOptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.LambdaFunctionMemoryRecommendationOption
            .wrap(item)
        }.toList
      )
    override val currentPerformanceRisk
        : Option[zio.aws.computeoptimizer.model.CurrentPerformanceRisk] = scala
      .Option(impl.currentPerformanceRisk())
      .map(value =>
        zio.aws.computeoptimizer.model.CurrentPerformanceRisk.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendation
  ): zio.aws.computeoptimizer.model.LambdaFunctionRecommendation.ReadOnly =
    new Wrapper(impl)
}
