package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.computeoptimizer.model.primitives.ResourceArn
import scala.jdk.CollectionConverters._
final case class GetEffectiveRecommendationPreferencesRequest(
    resourceArn: ResourceArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.GetEffectiveRecommendationPreferencesRequest = {
    import GetEffectiveRecommendationPreferencesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.GetEffectiveRecommendationPreferencesRequest
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.GetEffectiveRecommendationPreferencesRequest.ReadOnly =
    zio.aws.computeoptimizer.model.GetEffectiveRecommendationPreferencesRequest
      .wrap(buildAwsValue())
}
object GetEffectiveRecommendationPreferencesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.GetEffectiveRecommendationPreferencesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.GetEffectiveRecommendationPreferencesRequest =
      zio.aws.computeoptimizer.model
        .GetEffectiveRecommendationPreferencesRequest(resourceArn)
    def resourceArn: ResourceArn
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetEffectiveRecommendationPreferencesRequest
  ) extends zio.aws.computeoptimizer.model.GetEffectiveRecommendationPreferencesRequest.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.computeoptimizer.model.primitives.ResourceArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetEffectiveRecommendationPreferencesRequest
  ): zio.aws.computeoptimizer.model.GetEffectiveRecommendationPreferencesRequest.ReadOnly =
    new Wrapper(impl)
}
