package zio.aws.comprehend.model
import scala.jdk.CollectionConverters.*
sealed trait DatasetStatus {
  def unwrap: software.amazon.awssdk.services.comprehend.model.DatasetStatus
}
object DatasetStatus {
  def wrap(
      value: software.amazon.awssdk.services.comprehend.model.DatasetStatus
  ): zio.aws.comprehend.model.DatasetStatus = value match {
    case software.amazon.awssdk.services.comprehend.model.DatasetStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.comprehend.model.DatasetStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.comprehend.model.DatasetStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.comprehend.model.DatasetStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.comprehend.model.DatasetStatus {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.DatasetStatus =
      software.amazon.awssdk.services.comprehend.model.DatasetStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.comprehend.model.DatasetStatus {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.DatasetStatus =
      software.amazon.awssdk.services.comprehend.model.DatasetStatus.CREATING
  }
  case object COMPLETED extends zio.aws.comprehend.model.DatasetStatus {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.DatasetStatus =
      software.amazon.awssdk.services.comprehend.model.DatasetStatus.COMPLETED
  }
  case object FAILED extends zio.aws.comprehend.model.DatasetStatus {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.DatasetStatus =
      software.amazon.awssdk.services.comprehend.model.DatasetStatus.FAILED
  }
}
