package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.EntityRecognizerArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteEntityRecognizerRequest(
    entityRecognizerArn: EntityRecognizerArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DeleteEntityRecognizerRequest = {
    import DeleteEntityRecognizerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DeleteEntityRecognizerRequest
      .builder()
      .entityRecognizerArn(
        EntityRecognizerArn.unwrap(entityRecognizerArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.DeleteEntityRecognizerRequest.ReadOnly =
    zio.aws.comprehend.model.DeleteEntityRecognizerRequest.wrap(buildAwsValue())
}
object DeleteEntityRecognizerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DeleteEntityRecognizerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DeleteEntityRecognizerRequest =
      zio.aws.comprehend.model
        .DeleteEntityRecognizerRequest(entityRecognizerArn)
    def entityRecognizerArn: EntityRecognizerArn
    def getEntityRecognizerArn: ZIO[Any, Nothing, EntityRecognizerArn] =
      ZIO.succeed(entityRecognizerArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DeleteEntityRecognizerRequest
  ) extends zio.aws.comprehend.model.DeleteEntityRecognizerRequest.ReadOnly {
    override val entityRecognizerArn: EntityRecognizerArn =
      zio.aws.comprehend.model.primitives
        .EntityRecognizerArn(impl.entityRecognizerArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DeleteEntityRecognizerRequest
  ): zio.aws.comprehend.model.DeleteEntityRecognizerRequest.ReadOnly =
    new Wrapper(impl)
}
