package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RelationshipsListItem(
    ids: Optional[Iterable[String]] = Optional.Absent,
    `type`: Optional[zio.aws.comprehend.model.RelationshipType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.RelationshipsListItem = {
    import RelationshipsListItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.RelationshipsListItem
      .builder()
      .optionallyWith(
        ids.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.ids)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.RelationshipsListItem.ReadOnly =
    zio.aws.comprehend.model.RelationshipsListItem.wrap(buildAwsValue())
}
object RelationshipsListItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.RelationshipsListItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.RelationshipsListItem =
      zio.aws.comprehend.model.RelationshipsListItem(
        ids.map(value => value),
        `type`.map(value => value)
      )
    def ids: Optional[List[String]]
    def `type`: Optional[zio.aws.comprehend.model.RelationshipType]
    def getIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("ids", ids)
    def getType: ZIO[Any, AwsError, zio.aws.comprehend.model.RelationshipType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.RelationshipsListItem
  ) extends zio.aws.comprehend.model.RelationshipsListItem.ReadOnly {
    override val ids: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.ids())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val `type`: Optional[zio.aws.comprehend.model.RelationshipType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.comprehend.model.RelationshipType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.RelationshipsListItem
  ): zio.aws.comprehend.model.RelationshipsListItem.ReadOnly = new Wrapper(impl)
}
