package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListEntityRecognizersResponse(
    entityRecognizerPropertiesList: Optional[
      Iterable[zio.aws.comprehend.model.EntityRecognizerProperties]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersResponse = {
    import ListEntityRecognizersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersResponse
      .builder()
      .optionallyWith(
        entityRecognizerPropertiesList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.entityRecognizerPropertiesList)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.ListEntityRecognizersResponse.ReadOnly =
    zio.aws.comprehend.model.ListEntityRecognizersResponse.wrap(buildAwsValue())
}
object ListEntityRecognizersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.ListEntityRecognizersResponse =
      zio.aws.comprehend.model.ListEntityRecognizersResponse(
        entityRecognizerPropertiesList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def entityRecognizerPropertiesList: Optional[
      List[zio.aws.comprehend.model.EntityRecognizerProperties.ReadOnly]
    ]
    def nextToken: Optional[String]
    def getEntityRecognizerPropertiesList: ZIO[Any, AwsError, List[
      zio.aws.comprehend.model.EntityRecognizerProperties.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "entityRecognizerPropertiesList",
      entityRecognizerPropertiesList
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersResponse
  ) extends zio.aws.comprehend.model.ListEntityRecognizersResponse.ReadOnly {
    override val entityRecognizerPropertiesList: Optional[
      List[zio.aws.comprehend.model.EntityRecognizerProperties.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.entityRecognizerPropertiesList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.comprehend.model.EntityRecognizerProperties.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersResponse
  ): zio.aws.comprehend.model.ListEntityRecognizersResponse.ReadOnly =
    new Wrapper(impl)
}
