package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DetectTargetedSentimentResponse(
    entities: Optional[
      Iterable[zio.aws.comprehend.model.TargetedSentimentEntity]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DetectTargetedSentimentResponse = {
    import DetectTargetedSentimentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DetectTargetedSentimentResponse
      .builder()
      .optionallyWith(
        entities.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.entities)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.DetectTargetedSentimentResponse.ReadOnly =
    zio.aws.comprehend.model.DetectTargetedSentimentResponse
      .wrap(buildAwsValue())
}
object DetectTargetedSentimentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DetectTargetedSentimentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DetectTargetedSentimentResponse =
      zio.aws.comprehend.model.DetectTargetedSentimentResponse(
        entities.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def entities: Optional[
      List[zio.aws.comprehend.model.TargetedSentimentEntity.ReadOnly]
    ]
    def getEntities: ZIO[Any, AwsError, List[
      zio.aws.comprehend.model.TargetedSentimentEntity.ReadOnly
    ]] = AwsError.unwrapOptionField("entities", entities)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DetectTargetedSentimentResponse
  ) extends zio.aws.comprehend.model.DetectTargetedSentimentResponse.ReadOnly {
    override val entities: Optional[
      List[zio.aws.comprehend.model.TargetedSentimentEntity.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.entities())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.comprehend.model.TargetedSentimentEntity.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DetectTargetedSentimentResponse
  ): zio.aws.comprehend.model.DetectTargetedSentimentResponse.ReadOnly =
    new Wrapper(impl)
}
