package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TargetedSentimentMention(
    score: Optional[Float] = Optional.Absent,
    groupScore: Optional[Float] = Optional.Absent,
    text: Optional[String] = Optional.Absent,
    `type`: Optional[zio.aws.comprehend.model.TargetedSentimentEntityType] =
      Optional.Absent,
    mentionSentiment: Optional[zio.aws.comprehend.model.MentionSentiment] =
      Optional.Absent,
    beginOffset: Optional[Integer] = Optional.Absent,
    endOffset: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.TargetedSentimentMention = {
    import TargetedSentimentMention.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.TargetedSentimentMention
      .builder()
      .optionallyWith(score.map(value => value: java.lang.Float))(_.score)
      .optionallyWith(groupScore.map(value => value: java.lang.Float))(
        _.groupScore
      )
      .optionallyWith(text.map(value => value: java.lang.String))(_.text)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(mentionSentiment.map(value => value.buildAwsValue()))(
        _.mentionSentiment
      )
      .optionallyWith(beginOffset.map(value => value: java.lang.Integer))(
        _.beginOffset
      )
      .optionallyWith(endOffset.map(value => value: java.lang.Integer))(
        _.endOffset
      )
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.TargetedSentimentMention.ReadOnly =
    zio.aws.comprehend.model.TargetedSentimentMention.wrap(buildAwsValue())
}
object TargetedSentimentMention {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.TargetedSentimentMention
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.TargetedSentimentMention =
      zio.aws.comprehend.model.TargetedSentimentMention(
        score.map(value => value),
        groupScore.map(value => value),
        text.map(value => value),
        `type`.map(value => value),
        mentionSentiment.map(value => value.asEditable),
        beginOffset.map(value => value),
        endOffset.map(value => value)
      )
    def score: Optional[Float]
    def groupScore: Optional[Float]
    def text: Optional[String]
    def `type`: Optional[zio.aws.comprehend.model.TargetedSentimentEntityType]
    def mentionSentiment
        : Optional[zio.aws.comprehend.model.MentionSentiment.ReadOnly]
    def beginOffset: Optional[Integer]
    def endOffset: Optional[Integer]
    def getScore: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("score", score)
    def getGroupScore: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("groupScore", groupScore)
    def getText: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("text", text)
    def getType: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.TargetedSentimentEntityType
    ] = AwsError.unwrapOptionField("type", `type`)
    def getMentionSentiment: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.MentionSentiment.ReadOnly
    ] = AwsError.unwrapOptionField("mentionSentiment", mentionSentiment)
    def getBeginOffset: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("beginOffset", beginOffset)
    def getEndOffset: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("endOffset", endOffset)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.TargetedSentimentMention
  ) extends zio.aws.comprehend.model.TargetedSentimentMention.ReadOnly {
    override val score: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.score())
      .map(value => value: Float)
    override val groupScore: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.groupScore())
      .map(value => value: Float)
    override val text: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.text())
      .map(value => value: String)
    override val `type`
        : Optional[zio.aws.comprehend.model.TargetedSentimentEntityType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          zio.aws.comprehend.model.TargetedSentimentEntityType.wrap(value)
        )
    override val mentionSentiment
        : Optional[zio.aws.comprehend.model.MentionSentiment.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mentionSentiment())
        .map(value => zio.aws.comprehend.model.MentionSentiment.wrap(value))
    override val beginOffset: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.beginOffset())
      .map(value => value: Integer)
    override val endOffset: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.endOffset())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.TargetedSentimentMention
  ): zio.aws.comprehend.model.TargetedSentimentMention.ReadOnly = new Wrapper(
    impl
  )
}
