package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.{
  ClientRequestTokenString,
  Description,
  ComprehendArnName,
  ComprehendFlywheelArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateDatasetRequest(
    flywheelArn: ComprehendFlywheelArn,
    datasetName: ComprehendArnName,
    datasetType: Optional[zio.aws.comprehend.model.DatasetType] =
      Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    inputDataConfig: zio.aws.comprehend.model.DatasetInputDataConfig,
    clientRequestToken: Optional[ClientRequestTokenString] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.comprehend.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.CreateDatasetRequest = {
    import CreateDatasetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.CreateDatasetRequest
      .builder()
      .flywheelArn(ComprehendFlywheelArn.unwrap(flywheelArn): java.lang.String)
      .datasetName(ComprehendArnName.unwrap(datasetName): java.lang.String)
      .optionallyWith(datasetType.map(value => value.unwrap))(_.datasetType)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .inputDataConfig(inputDataConfig.buildAwsValue())
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestTokenString.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.CreateDatasetRequest.ReadOnly =
    zio.aws.comprehend.model.CreateDatasetRequest.wrap(buildAwsValue())
}
object CreateDatasetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.CreateDatasetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.CreateDatasetRequest =
      zio.aws.comprehend.model.CreateDatasetRequest(
        flywheelArn,
        datasetName,
        datasetType.map(value => value),
        description.map(value => value),
        inputDataConfig.asEditable,
        clientRequestToken.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def flywheelArn: ComprehendFlywheelArn
    def datasetName: ComprehendArnName
    def datasetType: Optional[zio.aws.comprehend.model.DatasetType]
    def description: Optional[Description]
    def inputDataConfig
        : zio.aws.comprehend.model.DatasetInputDataConfig.ReadOnly
    def clientRequestToken: Optional[ClientRequestTokenString]
    def tags: Optional[List[zio.aws.comprehend.model.Tag.ReadOnly]]
    def getFlywheelArn: ZIO[Any, Nothing, ComprehendFlywheelArn] =
      ZIO.succeed(flywheelArn)
    def getDatasetName: ZIO[Any, Nothing, ComprehendArnName] =
      ZIO.succeed(datasetName)
    def getDatasetType
        : ZIO[Any, AwsError, zio.aws.comprehend.model.DatasetType] =
      AwsError.unwrapOptionField("datasetType", datasetType)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getInputDataConfig: ZIO[
      Any,
      Nothing,
      zio.aws.comprehend.model.DatasetInputDataConfig.ReadOnly
    ] = ZIO.succeed(inputDataConfig)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestTokenString] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.comprehend.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.CreateDatasetRequest
  ) extends zio.aws.comprehend.model.CreateDatasetRequest.ReadOnly {
    override val flywheelArn: ComprehendFlywheelArn =
      zio.aws.comprehend.model.primitives
        .ComprehendFlywheelArn(impl.flywheelArn())
    override val datasetName: ComprehendArnName =
      zio.aws.comprehend.model.primitives.ComprehendArnName(impl.datasetName())
    override val datasetType: Optional[zio.aws.comprehend.model.DatasetType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datasetType())
        .map(value => zio.aws.comprehend.model.DatasetType.wrap(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.comprehend.model.primitives.Description(value))
    override val inputDataConfig
        : zio.aws.comprehend.model.DatasetInputDataConfig.ReadOnly =
      zio.aws.comprehend.model.DatasetInputDataConfig
        .wrap(impl.inputDataConfig())
    override val clientRequestToken: Optional[ClientRequestTokenString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.comprehend.model.primitives.ClientRequestTokenString(value)
        )
    override val tags: Optional[List[zio.aws.comprehend.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.comprehend.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.CreateDatasetRequest
  ): zio.aws.comprehend.model.CreateDatasetRequest.ReadOnly = new Wrapper(impl)
}
